/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.common;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import us.ajg0702.queue.api.EventHandler;
import us.ajg0702.queue.api.events.AutoQueueOnKickEvent;
import us.ajg0702.queue.api.events.SuccessfulSendEvent;
import us.ajg0702.queue.api.players.AdaptedPlayer;
import us.ajg0702.queue.api.players.QueuePlayer;
import us.ajg0702.queue.api.queues.QueueServer;
import us.ajg0702.queue.api.server.AdaptedServer;
import us.ajg0702.queue.commands.commands.manage.PauseQueueServer;
import us.ajg0702.queue.commands.commands.queue.QueueCommand;
import us.ajg0702.queue.common.QueueMain;
import us.ajg0702.queue.common.communication.CommunicationManager;
import us.ajg0702.queue.common.players.QueuePlayerImpl;
import us.ajg0702.queue.common.utils.Debug;

public class EventHandlerImpl
implements EventHandler {
    final QueueMain main;
    CommunicationManager communicationManager;
    private final Map<String, Long> recentlyChanged = new ConcurrentHashMap<String, Long>();

    public EventHandlerImpl(QueueMain main) {
        this.main = main;
    }

    @Override
    public void handleMessage(AdaptedPlayer receivingPlayer, byte[] data) {
        if (!receivingPlayer.isConnected()) {
            return;
        }
        if (this.communicationManager == null) {
            this.communicationManager = new CommunicationManager(this.main);
        }
        try {
            this.communicationManager.handle(receivingPlayer, data);
        }
        catch (IOException e) {
            this.main.getLogger().warning("An error occurred while reading data from spigot side:", e);
        }
    }

    @Override
    public void onPlayerJoin(AdaptedPlayer player) {
        if (player.hasPermission("ajqueue.manage.update")) {
            this.main.getTaskManager().runLater(() -> {
                if (this.main.getUpdateManager().isUpdateAvailable() && !this.main.getUpdateManager().isAlreadyDownloaded()) {
                    player.sendMessage(this.main.getMessages().getComponent("updater.update-available", new String[0]));
                }
            }, 2L, TimeUnit.SECONDS);
        }
        ImmutableList<QueuePlayer> queues = this.main.getQueueManager().findPlayerInQueues(player);
        for (QueuePlayer queuePlayer : queues) {
            queuePlayer.setPlayer(player);
        }
        if (queues.size() > 0) {
            this.main.getQueueManager().sendMessage(this.main.getQueueManager().getSingleServer(player).findPlayer(player));
        }
        this.main.serverTimeManager.playerChanged(player);
    }

    @Override
    public void onPlayerLeave(AdaptedPlayer player) {
        ImmutableList<QueuePlayer> queues = this.main.getQueueManager().findPlayerInQueues(player);
        for (QueuePlayer queuePlayer : queues) {
            ((QueuePlayerImpl)queuePlayer).setLeaveTime(System.currentTimeMillis());
        }
        this.main.getQueueManager().clear(player);
        QueueCommand.cooldowns.remove(player);
        this.main.serverTimeManager.removePlayer(player);
        this.recentlyChanged.keySet().removeIf(k -> k.startsWith(player.getUniqueId().toString()));
    }

    @Override
    public void onPlayerJoinServer(AdaptedPlayer player) {
        ImmutableList<QueuePlayer> alreadyqueued = this.main.getQueueManager().findPlayerInQueues(player);
        for (QueuePlayer queuePlayer : alreadyqueued) {
            QueueServer server = queuePlayer.getQueueServer();
            int pos = queuePlayer.getPosition();
            if ((pos > 1 || !server.getServerNames().contains((Object)player.getServerName())) && !this.main.getConfig().getBoolean("remove-player-on-server-switch")) continue;
            server.removePlayer(player);
            server.setLastSentTime(System.currentTimeMillis());
            this.main.getQueueManager().getSendingAttempts().remove(queuePlayer);
            this.main.getTaskManager().runNow(() -> this.main.call(new SuccessfulSendEvent(queuePlayer, player.getCurrentServer())));
        }
        if (this.main.getConfig().getBoolean("include-server-switch-in-cooldown")) {
            QueueCommand.cooldowns.put(player, System.currentTimeMillis());
        }
        if (!PauseQueueServer.pausedPlayers.contains(player)) {
            String serverName = player.getServerName();
            List<String> svs = this.main.getConfig().getStringList("queue-servers");
            for (String s : svs) {
                if (!s.contains(":")) continue;
                String[] parts = s.split(":");
                String from = parts[0];
                QueueServer to = this.main.getQueueManager().findServer(parts[1]);
                if (!from.equalsIgnoreCase(serverName) || to == null || this.main.getConfig().getBoolean("require-queueserver-permission") && !player.hasPermission("ajqueue.queueserver." + to.getName())) continue;
                int delay = Math.min(this.main.getConfig().getInt("queue-server-delay"), 3000);
                Runnable task = () -> {
                    if (to.getServers().contains((Object)player.getCurrentServer())) {
                        return;
                    }
                    if (to.findPlayer(player) != null) {
                        return;
                    }
                    this.main.getQueueManager().addToQueue(player, to);
                };
                Debug.info("Delaying queue-server by " + delay);
                if (delay > 0) {
                    this.main.getTaskManager().executor.schedule(task, (long)delay, TimeUnit.MILLISECONDS);
                    continue;
                }
                task.run();
            }
        }
        this.main.serverTimeManager.playerChanged(player);
    }

    @Override
    public void onServerKick(AdaptedPlayer player, @NotNull AdaptedServer from, Component reason, boolean moving) {
        ImmutableList<QueueServer> queuedServers;
        if (!player.isConnected()) {
            return;
        }
        String plainReason = PlainTextComponentSerializer.plainText().serialize(reason);
        Debug.info(player.getName() + " kicked! Moving: " + moving + " from: " + from.getName() + " plainReason: " + plainReason);
        if (!moving && this.main.getConfig().getBoolean("send-fail-debug")) {
            this.main.getLogger().warning("Failed to send " + player.getName() + " to " + from.getName() + ". Kicked with reason: " + plainReason);
        }
        if (!(queuedServers = this.main.getQueueManager().getPlayerQueues(player)).contains((Object)this.main.getQueueManager().findServer(from.getName())) && this.main.getConfig().getBoolean("auto-add-to-queue-on-kick")) {
            List<String> excludedServers;
            List<String> reasons = this.main.getConfig().getStringList("auto-add-kick-reasons");
            boolean shouldqueue = false;
            for (String kickReason : reasons) {
                if (!plainReason.toLowerCase().contains(kickReason.toLowerCase())) continue;
                shouldqueue = true;
                break;
            }
            if ((shouldqueue || reasons.isEmpty()) && !(excludedServers = this.main.getConfig().getStringList("auto-add-excluded-servers")).contains(from.getName())) {
                this.main.getTaskManager().runLater(() -> {
                    if (!player.isConnected()) {
                        return;
                    }
                    AutoQueueOnKickEvent event = new AutoQueueOnKickEvent(player, from.getName());
                    this.main.call(event);
                    if (!event.isCancelled()) {
                        String toName = event.getTargetServer();
                        player.sendMessage(this.main.getMessages().getComponent("auto-queued", "SERVER:" + this.main.getAliasManager().getAlias(toName)));
                        this.main.getQueueManager().addToQueue(player, toName);
                    }
                }, (long)(this.main.getConfig().getDouble("auto-add-to-queue-on-kick-delay") * 1000.0), TimeUnit.MILLISECONDS);
                return;
            }
        }
        block1: for (QueueServer server : queuedServers) {
            QueuePlayer queuePlayer;
            if (!server.getServerNames().contains((Object)from.getName()) || (queuePlayer = server.findPlayer(player)).getPosition() != 1) continue;
            List<String> kickReasons = this.main.getConfig().getStringList("kick-reasons");
            boolean kickPlayer = this.main.getConfig().getBoolean("kick-kicked-players");
            if (kickPlayer) {
                Debug.info("Initially kicking player");
                List<String> svs = this.main.getConfig().getStringList("queue-servers");
                boolean found = false;
                for (String s : svs) {
                    if (!s.contains(":")) continue;
                    String[] parts = s.split(":");
                    String fromName = parts[0];
                    QueueServer toServer = this.main.getQueueManager().findServer(parts[1]);
                    if (toServer == null) continue;
                    Debug.info("fromName equals: " + fromName.equalsIgnoreCase(player.getServerName()) + " (" + fromName + " = " + player.getServerName() + ") toServer equals: " + toServer.equals(server));
                    if (!fromName.equalsIgnoreCase(player.getServerName()) || !toServer.equals(server)) continue;
                    found = true;
                }
                kickPlayer = found;
            }
            Debug.info("Kick player: " + kickPlayer);
            for (String kickReason : kickReasons) {
                if (!plainReason.toLowerCase().contains(kickReason.toLowerCase())) continue;
                server.removePlayer(queuePlayer);
                if (!kickPlayer) continue block1;
                player.kick(reason);
                continue block1;
            }
        }
    }

    @Override
    @Nullable
    public AdaptedServer changeTargetServer(AdaptedPlayer player, AdaptedServer initialChoice) {
        if (!this.main.getConfig().getBoolean("skip-queue-server-if-possible")) {
            return null;
        }
        if (PauseQueueServer.pausedPlayers.contains(player)) {
            return null;
        }
        Map<String, List<String>> queueServers = this.main.getQueueServers();
        List<String> toNames = queueServers.get(initialChoice.getName());
        if (toNames == null || toNames.isEmpty()) {
            return null;
        }
        for (String toName : toNames) {
            AdaptedServer ideal;
            QueueServer to = this.main.getQueueManager().findServer(toName);
            if (!this.main.getQueueManager().canSendInstantly(player, to) || (ideal = to.getIdealServer(player)) == null || !to.isJoinable(player) || !ideal.isJoinable(player) || this.main.getConfig().getBoolean("require-queueserver-permission") && !player.hasPermission("ajqueue.queueserver." + to.getName())) continue;
            String key = player.getUniqueId() + ":" + toName;
            if ((double)(System.currentTimeMillis() - this.recentlyChanged.getOrDefault(key, 0L)) <= this.main.getConfig().getDouble("wait-time") * 1000.0) continue;
            Debug.info("Skipping queue-server " + initialChoice.getName() + " for " + player.getName() + " because they would be sent instantly! (skip-queue-server-if-possible)");
            ideal.addPlayer();
            this.recentlyChanged.put(key, System.currentTimeMillis());
            player.sendMessage(this.main.getMessages().getComponent("status.skipping-queue-server", new String[0]));
            return ideal;
        }
        return null;
    }
}

