/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.platforms.velocity;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.api.plugin.PluginContainer;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import com.velocitypowered.api.proxy.messages.MinecraftChannelIdentifier;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import us.ajg0702.queue.api.PlatformMethods;
import us.ajg0702.queue.api.commands.IBaseCommand;
import us.ajg0702.queue.api.commands.ICommandSender;
import us.ajg0702.queue.api.players.AdaptedPlayer;
import us.ajg0702.queue.api.server.AdaptedServer;
import us.ajg0702.queue.api.util.QueueLogger;
import us.ajg0702.queue.commands.commands.PlayerSender;
import us.ajg0702.queue.common.utils.Debug;
import us.ajg0702.queue.platforms.velocity.VelocityQueue;
import us.ajg0702.queue.platforms.velocity.players.VelocityPlayer;
import us.ajg0702.queue.platforms.velocity.server.VelocityServer;

public class VelocityMethods
implements PlatformMethods {
    final ProxyServer proxyServer;
    final QueueLogger logger;
    final VelocityQueue plugin;
    List<VelocityServer> serverList = new ArrayList<VelocityServer>();

    public VelocityMethods(VelocityQueue plugin, ProxyServer proxyServer, QueueLogger logger) {
        this.proxyServer = proxyServer;
        this.logger = logger;
        this.plugin = plugin;
    }

    @Override
    public void sendPluginMessage(AdaptedPlayer player, String channel, String ... data) {
        if (player == null) {
            return;
        }
        if (this.plugin.getMain().getConfig().getBoolean("disable-proxy-communication")) {
            return;
        }
        Player velocityPlayer = ((VelocityPlayer)player).getHandle();
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        String playerName = player.getName();
        if (playerName == null) {
            return;
        }
        out.writeUTF(channel);
        for (String s : data) {
            out.writeUTF(s);
        }
        Optional server = velocityPlayer.getCurrentServer();
        if (!server.isPresent()) {
            this.logger.warn("Unable to send message to " + player.getName() + ", as they are not connected to any server!");
            return;
        }
        ((ServerConnection)server.get()).sendPluginMessage((ChannelIdentifier)MinecraftChannelIdentifier.from((String)"ajqueue:tospigot"), out.toByteArray());
    }

    @Override
    public AdaptedPlayer senderToPlayer(ICommandSender sender) {
        if (sender instanceof PlayerSender) {
            return ((PlayerSender)sender).getHandle();
        }
        return new VelocityPlayer((Player)sender.getHandle());
    }

    @Override
    public String getPluginVersion() {
        Optional plugin = this.proxyServer.getPluginManager().getPlugin("ajqueue");
        if (!plugin.isPresent()) {
            return "?E";
        }
        Optional version = ((PluginContainer)plugin.get()).getDescription().getVersion();
        return version.orElse("?V");
    }

    @Override
    public List<AdaptedPlayer> getOnlinePlayers() {
        ArrayList<AdaptedPlayer> players = new ArrayList<AdaptedPlayer>();
        for (Player player : this.proxyServer.getAllPlayers()) {
            players.add(new VelocityPlayer(player));
        }
        return players;
    }

    @Override
    public List<String> getPlayerNames(boolean lowercase) {
        ArrayList<String> players = new ArrayList<String>();
        for (Player player : this.proxyServer.getAllPlayers()) {
            if (lowercase) {
                players.add(player.getUsername().toLowerCase(Locale.ROOT));
                continue;
            }
            players.add(player.getUsername());
        }
        return players;
    }

    @Override
    public AdaptedPlayer getPlayer(String name) {
        Optional player = this.proxyServer.getPlayer(name);
        if (!player.isPresent()) {
            return null;
        }
        return new VelocityPlayer((Player)player.get());
    }

    @Override
    public AdaptedPlayer getPlayer(UUID uuid) {
        Optional player = this.proxyServer.getPlayer(uuid);
        if (!player.isPresent()) {
            return null;
        }
        return new VelocityPlayer((Player)player.get());
    }

    @Override
    public List<String> getServerNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (RegisteredServer server : this.proxyServer.getAllServers()) {
            names.add(server.getServerInfo().getName());
        }
        return names;
    }

    @Override
    public String getImplementationName() {
        return "velocity";
    }

    @Override
    public List<IBaseCommand> getCommands() {
        return this.plugin.commands;
    }

    @Override
    public boolean hasPlugin(String pluginName) {
        return this.proxyServer.getPluginManager().getPlugin(pluginName.toLowerCase(Locale.ROOT)).isPresent();
    }

    @Override
    public AdaptedServer getServer(String name) {
        List<? extends AdaptedServer> servers = this.getServers();
        for (AdaptedServer adaptedServer : servers) {
            if (!adaptedServer.getName().equals(name)) continue;
            return adaptedServer;
        }
        return null;
    }

    @Override
    public List<? extends AdaptedServer> getServers() {
        boolean found;
        for (RegisteredServer registeredServer : this.proxyServer.getAllServers()) {
            found = false;
            for (VelocityServer sv : new ArrayList<VelocityServer>(this.serverList)) {
                if (!sv.getHandle().equals(registeredServer)) continue;
                found = true;
                break;
            }
            if (found) continue;
            Debug.info("Added " + registeredServer.getServerInfo().getName());
            this.serverList.add(new VelocityServer(registeredServer));
        }
        for (VelocityServer sv : new ArrayList<VelocityServer>(this.serverList)) {
            found = false;
            for (RegisteredServer registeredServer : this.proxyServer.getAllServers()) {
                if (!sv.getHandle().equals(registeredServer)) continue;
                found = true;
                break;
            }
            if (found) continue;
            Debug.info("Removed " + sv.getName());
            this.serverList.remove(sv);
        }
        return this.serverList;
    }

    @Override
    public String getProtocolName(int protocol) {
        String version = ProtocolVersion.getProtocolVersion((int)protocol).getMostRecentSupportedVersion();
        if (version.equalsIgnoreCase("Unknown")) {
            return protocol + "";
        }
        return version;
    }
}

