/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.commands.commands.manage;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import us.ajg0702.queue.api.commands.IBaseCommand;
import us.ajg0702.queue.api.commands.ICommandSender;
import us.ajg0702.queue.api.commands.ISubCommand;
import us.ajg0702.queue.commands.BaseCommand;
import us.ajg0702.queue.commands.commands.manage.Kick;
import us.ajg0702.queue.commands.commands.manage.KickAll;
import us.ajg0702.queue.commands.commands.manage.Pause;
import us.ajg0702.queue.commands.commands.manage.PauseQueueServer;
import us.ajg0702.queue.commands.commands.manage.QueueList;
import us.ajg0702.queue.commands.commands.manage.Reload;
import us.ajg0702.queue.commands.commands.manage.Send;
import us.ajg0702.queue.commands.commands.manage.Update;
import us.ajg0702.queue.commands.commands.manage.debug.ISP;
import us.ajg0702.queue.commands.commands.manage.debug.PermissionList;
import us.ajg0702.queue.commands.commands.manage.debug.Protocol;
import us.ajg0702.queue.commands.commands.manage.debug.Tasks;
import us.ajg0702.queue.commands.commands.manage.debug.Version;
import us.ajg0702.queue.commands.commands.manage.debug.Whitelist;
import us.ajg0702.queue.common.QueueMain;
import us.ajg0702.queue.libs.utils.common.Messages;

public class ManageCommand
extends BaseCommand {
    final QueueMain main;
    final Component usage;
    final List<ISubCommand> subCommands = new ArrayList<ISubCommand>();

    public ManageCommand(QueueMain main) {
        this.main = main;
        this.addSubCommand(new Protocol(main));
        this.addSubCommand(new ISP(main));
        this.addSubCommand(new PermissionList(main));
        this.addSubCommand(new Tasks(main));
        this.addSubCommand(new Version(main));
        this.addSubCommand(new Whitelist(main));
        this.addSubCommand(new Reload(main));
        this.addSubCommand(new Pause(main));
        this.addSubCommand(new QueueList(main));
        this.addSubCommand(new Send(main));
        this.addSubCommand(new Update(main));
        this.addSubCommand(new Kick(main));
        this.addSubCommand(new KickAll(main));
        this.addSubCommand(new PauseQueueServer(main));
        this.usage = main.getMessages().toComponent("/ajQueue &7<&r" + this.subCommands.stream().filter(IBaseCommand::showInTabComplete).map(IBaseCommand::getName).collect(Collectors.joining("&7|&r")) + "&7>&r");
    }

    @Override
    public String getName() {
        return "ajqueue";
    }

    @Override
    public ImmutableList<String> getAliases() {
        return ImmutableList.of((Object)"ajq");
    }

    @Override
    public ImmutableList<ISubCommand> getSubCommands() {
        return ImmutableList.copyOf(this.subCommands);
    }

    @Override
    public String getPermission() {
        return "ajqueue.manage";
    }

    @Override
    public Messages getMessages() {
        return this.main.getMessages();
    }

    @Override
    public void addSubCommand(ISubCommand subCommand) {
        this.subCommands.add(subCommand);
    }

    @Override
    public void execute(ICommandSender sender, String[] args) {
        if (args.length > 0) {
            for (ISubCommand subCommand : this.subCommands) {
                if (!args[0].equalsIgnoreCase(subCommand.getName()) && !subCommand.getAliases().contains((Object)args[0].toLowerCase(Locale.ROOT))) continue;
                subCommand.execute(sender, Arrays.copyOfRange(args, 1, args.length));
                return;
            }
        }
        sender.sendMessage(this.usage);
    }

    @Override
    public List<String> autoComplete(ICommandSender sender, String[] args) {
        if (args.length > 1) {
            for (ISubCommand subCommand : this.subCommands) {
                if (!args[0].equalsIgnoreCase(subCommand.getName()) && !subCommand.getAliases().contains((Object)args[0].toLowerCase(Locale.ROOT)) || !sender.hasPermission(subCommand.getPermission())) continue;
                return subCommand.autoComplete(sender, Arrays.copyOfRange(args, 1, args.length));
            }
            return new ArrayList<String>();
        }
        ArrayList<String> commands = new ArrayList<String>();
        for (ISubCommand subCommand : this.subCommands) {
            if (!subCommand.showInTabComplete() || !sender.hasPermission(subCommand.getPermission())) continue;
            commands.add(subCommand.getName());
            commands.addAll((Collection<String>)subCommand.getAliases());
        }
        return this.filterCompletion(commands, args[0]);
    }
}

