/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.common;

import java.util.ArrayList;
import java.util.List;
import us.ajg0702.queue.api.Implementation;
import us.ajg0702.queue.commands.commands.SlashServer.SlashServerCommand;
import us.ajg0702.queue.common.QueueMain;

public class SlashServerManager {
    private final List<SlashServerCommand> serverCommands = new ArrayList<SlashServerCommand>();
    private final QueueMain main;
    private final Implementation implementation;

    public SlashServerManager(QueueMain main) {
        this.main = main;
        this.implementation = this.main.getImplementation();
        this.reload();
    }

    public void reload() {
        this.serverCommands.forEach(this.implementation::unregisterCommand);
        this.serverCommands.clear();
        List<String> slashServerServers = this.main.getConfig().getStringList("slash-servers");
        for (String rawServer : slashServerServers) {
            if (rawServer.contains(":") && this.main.isPremium()) {
                String[] parts = rawServer.split(":");
                String command = parts[0];
                String server = parts[1];
                SlashServerCommand slashServerCommand = new SlashServerCommand(this.main, command, server);
                this.serverCommands.add(slashServerCommand);
                this.implementation.registerCommand(slashServerCommand);
                continue;
            }
            SlashServerCommand command = new SlashServerCommand(this.main, rawServer);
            this.serverCommands.add(command);
            this.implementation.registerCommand(command);
        }
    }
}

