/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.spigot.placeholders.placeholders;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import us.ajg0702.queue.api.spigot.AjQueueSpigotAPI;
import us.ajg0702.queue.spigot.SpigotMain;
import us.ajg0702.queue.spigot.placeholders.Placeholder;

public class QueuedFor
extends Placeholder {
    private final String invalidMessage = "Invalid queue name";
    private final Map<String, String> cache = new ConcurrentHashMap<String, String>();
    private final Map<String, Long> lastFetch = new ConcurrentHashMap<String, Long>();

    public QueuedFor(SpigotMain plugin) {
        super(plugin);
    }

    @Override
    public String getRegex() {
        return "queuedfor_(.*)";
    }

    @Override
    public String parse(Matcher matcher, OfflinePlayer p) {
        String queue = matcher.group(1);
        String cached = this.cache.getOrDefault(queue, "...");
        if (System.currentTimeMillis() - this.lastFetch.getOrDefault(queue, 0L) > 2000L) {
            this.lastFetch.put(queue, System.currentTimeMillis());
            this.plugin.getScheduler().runTaskAsynchronously(() -> {
                if (!p.isOnline()) {
                    return;
                }
                try {
                    Integer response = AjQueueSpigotAPI.getInstance().getPlayersInQueue(queue).get(30L, TimeUnit.SECONDS);
                    this.cache.put(queue, response + "");
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof IllegalArgumentException) {
                        this.cache.put(queue, "Invalid queue name");
                    }
                    throw new RuntimeException(e);
                }
                catch (TimeoutException timeoutException) {
                    // empty catch block
                }
            });
        }
        return cached;
    }

    @Override
    public void cleanCache(Player player) {
    }
}

