/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.spigot.placeholders.placeholders;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import us.ajg0702.queue.api.spigot.AjQueueSpigotAPI;
import us.ajg0702.queue.spigot.SpigotMain;
import us.ajg0702.queue.spigot.placeholders.Placeholder;
import us.ajg0702.queue.spigot.placeholders.RefetchablePlaceholder;
import us.ajg0702.queue.spigot.utils.UUIDStringKey;

public class StatusPlayer
extends Placeholder
implements RefetchablePlaceholder {
    private final Map<UUIDStringKey, String> cache = new ConcurrentHashMap<UUIDStringKey, String>();
    private final Map<UUIDStringKey, Long> lastFetch = new ConcurrentHashMap<UUIDStringKey, Long>();

    public StatusPlayer(SpigotMain plugin) {
        super(plugin);
    }

    @Override
    public String getRegex() {
        return "status_(.*)_player";
    }

    @Override
    public String parse(Matcher matcher, OfflinePlayer p) {
        String queue = matcher.group(1);
        UUIDStringKey key = new UUIDStringKey(p.getUniqueId(), queue);
        if (!p.isOnline()) {
            return "You aren't online!?!";
        }
        if (System.currentTimeMillis() - this.lastFetch.getOrDefault(key, 0L) > 2000L) {
            this.refetch(p, key);
        }
        return this.cache.getOrDefault(key, "...");
    }

    @Override
    public void cleanCache(Player player) {
        this.cache.entrySet().removeIf(entry -> ((UUIDStringKey)entry.getKey()).getUuid().equals(player.getUniqueId()));
        this.lastFetch.entrySet().removeIf(entry -> ((UUIDStringKey)entry.getKey()).getUuid().equals(player.getUniqueId()));
    }

    @Override
    public void refetch(OfflinePlayer p) {
        List keys = this.cache.keySet().stream().filter(key -> key.getUuid().equals(p.getUniqueId())).collect(Collectors.toList());
        for (UUIDStringKey uuidStringKey : keys) {
            this.refetch(p, uuidStringKey);
        }
    }

    public void refetch(OfflinePlayer p, UUIDStringKey key) {
        this.lastFetch.put(key, System.currentTimeMillis());
        this.plugin.getScheduler().runTaskAsynchronously(() -> {
            if (!p.isOnline()) {
                return;
            }
            try {
                String response = AjQueueSpigotAPI.getInstance().getServerStatusString(key.getString(), p.getUniqueId()).get(30L, TimeUnit.SECONDS);
                this.cache.put(key, response);
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalArgumentException | TimeoutException exception) {
                // empty catch block
            }
        });
    }
}

