/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.api.queueholders;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import us.ajg0702.queue.api.AjQueueAPI;
import us.ajg0702.queue.api.queueholders.QueueHolder;
import us.ajg0702.queue.api.queues.QueueServer;

public class QueueHolderRegistry {
    private Map<String, Class<? extends QueueHolder>> holders = new ConcurrentHashMap<String, Class<? extends QueueHolder>>();

    public void register(String identifier, Class<? extends QueueHolder> holder) {
        this.holders.put(identifier, holder);
    }

    public QueueHolder getQueueHolder(QueueServer queueServer) {
        String queueHolderName = AjQueueAPI.getInstance().getConfig().getString("queue-holder");
        QueueHolder queueHolder = this.getQueueHolder(queueHolderName, queueServer);
        if (queueHolder == null) {
            AjQueueAPI.getInstance().getLogger().warn("Invalid queue-holder '" + queueHolderName + "'! Using the default one");
            return this.getQueueHolder("default", queueServer);
        }
        return queueHolder;
    }

    public QueueHolder getQueueHolder(String identifier, QueueServer queueServer) {
        Class<? extends QueueHolder> holder = this.holders.get(identifier);
        if (holder == null) {
            return null;
        }
        try {
            return holder.getConstructor(QueueServer.class).newInstance(queueServer);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("QueueHolder " + identifier + " is missing the required constructor!");
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

