/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.common;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import us.ajg0702.queue.api.players.QueuePlayer;
import us.ajg0702.queue.api.queueholders.QueueHolder;
import us.ajg0702.queue.api.queues.QueueServer;
import us.ajg0702.queue.api.queues.QueueType;

public class DefaultQueueHolder
extends QueueHolder {
    List<QueuePlayer> queue = new CopyOnWriteArrayList<QueuePlayer>();
    List<QueuePlayer> expressQueue = new CopyOnWriteArrayList<QueuePlayer>();

    public DefaultQueueHolder(QueueServer queueServer) {
        super(queueServer);
    }

    @Override
    public String getIdentifier() {
        return "default";
    }

    @Override
    public void addPlayer(QueuePlayer player) {
        if (player.isInStandardQueue()) {
            this.queue.add(player);
        } else {
            this.expressQueue.add(player);
        }
    }

    @Override
    public void addPlayer(QueuePlayer player, int position) {
        if (player.isInStandardQueue()) {
            this.queue.add(position, player);
        } else {
            this.expressQueue.add(position, player);
        }
    }

    @Override
    public void removePlayer(QueuePlayer player) {
        if (player.isInStandardQueue()) {
            this.queue.remove(player);
        } else {
            this.expressQueue.remove(player);
        }
    }

    @Override
    public QueuePlayer findPlayer(UUID uuid) {
        for (QueuePlayer queuePlayer : this.queue) {
            if (!queuePlayer.getUniqueId().equals(uuid)) continue;
            return queuePlayer;
        }
        for (QueuePlayer queuePlayer : this.expressQueue) {
            if (!queuePlayer.getUniqueId().equals(uuid)) continue;
            return queuePlayer;
        }
        return null;
    }

    @Override
    public QueuePlayer findPlayer(String name) {
        for (QueuePlayer queuePlayer : this.queue) {
            if (!queuePlayer.getName().equalsIgnoreCase(name)) continue;
            return queuePlayer;
        }
        for (QueuePlayer queuePlayer : this.expressQueue) {
            if (!queuePlayer.getName().equalsIgnoreCase(name)) continue;
            return queuePlayer;
        }
        return null;
    }

    @Override
    public int getStandardQueueSize() {
        return this.queue.size();
    }

    @Override
    public int getExpressQueueSize() {
        return this.expressQueue.size();
    }

    @Override
    public int getTotalQueueSize() {
        return this.queue.size() + this.expressQueue.size();
    }

    @Override
    public int getPosition(QueuePlayer player) {
        return (player.getQueueType() == QueueType.EXPRESS ? this.expressQueue : this.queue).indexOf(player) + 1;
    }

    @Override
    public List<QueuePlayer> getAllStandardPlayers() {
        return ImmutableList.copyOf(this.queue);
    }

    @Override
    public List<QueuePlayer> getAllExpressPlayers() {
        return ImmutableList.copyOf(this.expressQueue);
    }
}

