/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.platforms.bungeecord.server;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ServerPing;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import org.jetbrains.annotations.Nullable;
import us.ajg0702.queue.api.AjQueueAPI;
import us.ajg0702.queue.api.players.AdaptedPlayer;
import us.ajg0702.queue.api.server.AdaptedServer;
import us.ajg0702.queue.api.server.AdaptedServerInfo;
import us.ajg0702.queue.api.server.AdaptedServerPing;
import us.ajg0702.queue.api.util.QueueLogger;
import us.ajg0702.queue.platforms.bungeecord.players.BungeePlayer;
import us.ajg0702.queue.platforms.bungeecord.server.BungeeServerInfo;
import us.ajg0702.queue.platforms.bungeecord.server.BungeeServerPing;

public class BungeeServer
implements AdaptedServer {
    private final ServerInfo handle;
    private final BungeeServerInfo serverInfo;
    private AdaptedServerPing lastPing = null;
    private AdaptedServerPing lastSuccessfullPing = null;
    private long lastOffline;
    private int offlineTime = 0;

    public BungeeServer(ServerInfo handle) {
        this.handle = handle;
        this.serverInfo = new BungeeServerInfo(handle);
    }

    @Override
    public AdaptedServerInfo getServerInfo() {
        return this.serverInfo;
    }

    @Override
    public String getName() {
        return this.serverInfo.getName();
    }

    @Override
    public CompletableFuture<AdaptedServerPing> ping(boolean debug, QueueLogger logger) {
        CompletableFuture<AdaptedServerPing> future = new CompletableFuture<AdaptedServerPing>();
        long sent = System.currentTimeMillis();
        if (debug) {
            logger.info("[pinger] [" + this.getName() + "] sending ping");
        }
        this.handle.ping((pp, error) -> {
            if (error != null || pp == null) {
                this.markOffline(debug, logger, future, sent, error);
                return;
            }
            this.offlineTime = 0;
            BungeeServerPing ping = new BungeeServerPing((ServerPing)pp, sent);
            this.lastSuccessfullPing = ping;
            if (debug) {
                logger.info("[pinger] [" + this.getName() + "] online. motd: " + ping.getPlainDescription() + "  players: " + ping.getPlayerCount() + "/" + ping.getMaxPlayers());
            }
            future.complete(ping);
            this.lastPing = ping;
        });
        return future;
    }

    private void markOffline(boolean debug, QueueLogger logger, CompletableFuture<AdaptedServerPing> future, long sent, @Nullable Throwable e) {
        long lastOnline = this.lastSuccessfullPing == null ? 0L : this.lastSuccessfullPing.getFetchedTime();
        this.offlineTime = (int)Math.min(sent - lastOnline, Integer.MAX_VALUE) / 1000;
        this.lastOffline = sent;
        future.completeExceptionally(e);
        this.lastPing = null;
        if (debug) {
            logger.info("[pinger] [" + this.getName() + "] offline:", e);
        }
    }

    @Override
    public Optional<AdaptedServerPing> getLastPing() {
        return Optional.ofNullable(this.lastPing);
    }

    @Override
    public boolean canAccess(AdaptedPlayer player) {
        if (player == null) {
            return !this.handle.isRestricted();
        }
        return this.handle.canAccess((CommandSender)((ProxiedPlayer)player.getHandle()));
    }

    @Override
    public List<AdaptedPlayer> getPlayers() {
        ArrayList<AdaptedPlayer> players = new ArrayList<AdaptedPlayer>();
        this.handle.getPlayers().forEach(pp -> players.add(new BungeePlayer((ProxiedPlayer)pp)));
        return players;
    }

    @Override
    public int getOfflineTime() {
        return this.offlineTime;
    }

    @Override
    public boolean justWentOnline() {
        return (double)(System.currentTimeMillis() - this.lastOffline) <= AjQueueAPI.getInstance().getConfig().getDouble("wait-time") * 2.0 * 1000.0 && this.isOnline();
    }

    @Override
    public boolean shouldWaitAfterOnline() {
        return (double)(System.currentTimeMillis() - this.lastOffline) <= AjQueueAPI.getInstance().getConfig().getDouble("wait-after-online") * 2.0 * 1000.0 && this.getLastPing().isPresent();
    }

    public ServerInfo getHandle() {
        return this.handle;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BungeeServer)) {
            return false;
        }
        BungeeServer that = (BungeeServer)o;
        return this.getHandle().equals(that.getHandle());
    }

    public int hashCode() {
        return Objects.hash(this.getHandle());
    }
}

