/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.spigot.communication;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import us.ajg0702.queue.api.communication.ComResponse;
import us.ajg0702.queue.spigot.communication.ResponseKey;

public class ResponseManager {
    private final Map<ResponseKey, Consumer<ComResponse>> responseMap = new ConcurrentHashMap<ResponseKey, Consumer<ComResponse>>();

    public synchronized void awaitResponse(String id, String from, Consumer<ComResponse> callback) {
        ResponseKey key = new ResponseKey(id, from);
        this.responseMap.merge(key, callback, (a, b) -> r -> {
            b.accept(r);
            a.accept(r);
        });
    }

    public void executeResponse(ComResponse response) {
        ResponseKey key = new ResponseKey(response.getIdentifier(), response.getFrom());
        Consumer<ComResponse> callback = this.responseMap.get(key);
        if (callback == null) {
            return;
        }
        this.responseMap.remove(key);
        callback.accept(response);
    }
}

