/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.spigot.placeholders.placeholders;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import us.ajg0702.queue.api.spigot.AjQueueSpigotAPI;
import us.ajg0702.queue.api.spigot.MessagedResponse;
import us.ajg0702.queue.spigot.SpigotMain;
import us.ajg0702.queue.spigot.placeholders.Placeholder;
import us.ajg0702.queue.spigot.placeholders.RefetchablePlaceholder;

public class EstimatedTime
extends Placeholder
implements RefetchablePlaceholder {
    private final Map<UUID, String> cache = new ConcurrentHashMap<UUID, String>();
    private final Map<UUID, Long> lastFetch = new ConcurrentHashMap<UUID, Long>();

    public EstimatedTime(SpigotMain plugin) {
        super(plugin);
    }

    @Override
    public String getRegex() {
        return "estimated_time";
    }

    @Override
    public String parse(Matcher matcher, OfflinePlayer p) {
        if (System.currentTimeMillis() - this.lastFetch.getOrDefault(p.getUniqueId(), 0L) > 2000L) {
            this.refetch(p);
        }
        return this.cache.getOrDefault(p.getUniqueId(), "...");
    }

    @Override
    public void cleanCache(Player player) {
        this.cache.remove(player.getUniqueId());
        this.lastFetch.remove(player.getUniqueId());
    }

    @Override
    public void refetch(OfflinePlayer p) {
        this.lastFetch.put(p.getUniqueId(), System.currentTimeMillis());
        this.plugin.getScheduler().runTaskAsynchronously(() -> {
            if (!p.isOnline()) {
                return;
            }
            try {
                MessagedResponse<String> response = AjQueueSpigotAPI.getInstance().getEstimatedTime(p.getUniqueId()).get(30L, TimeUnit.SECONDS);
                this.cache.put(p.getUniqueId(), response.getEither());
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalArgumentException | TimeoutException exception) {
                // empty catch block
            }
        });
    }
}

