/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.api.events;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import us.ajg0702.queue.api.events.Event;
import us.ajg0702.queue.api.server.AdaptedServer;

public class BuildServersEvent
implements Event {
    private final Map<String, AdaptedServer> servers = new HashMap<String, AdaptedServer>();
    private final Map<String, List<AdaptedServer>> groups = new HashMap<String, List<AdaptedServer>>();

    public BuildServersEvent(List<? extends AdaptedServer> servers) {
        for (AdaptedServer adaptedServer : servers) {
            this.servers.put(adaptedServer.getName(), adaptedServer);
        }
    }

    public List<AdaptedServer> getServers() {
        return Collections.unmodifiableList(new ArrayList<AdaptedServer>(this.servers.values()));
    }

    @Nullable
    public AdaptedServer addServer(AdaptedServer server) {
        return this.servers.put(server.getName(), server);
    }

    public boolean removeServer(AdaptedServer server) {
        return this.servers.remove(server.getName()) != null;
    }

    public boolean removeServer(String name) {
        return this.servers.remove(name) != null;
    }

    public List<List<AdaptedServer>> getGroups() {
        return Collections.unmodifiableList(new ArrayList<List<AdaptedServer>>(this.groups.values()));
    }

    public Set<Map.Entry<String, List<AdaptedServer>>> groupEntrySet() {
        return this.groups.entrySet();
    }

    @Nullable
    public List<AdaptedServer> addGroup(String name, List<AdaptedServer> servers) {
        return this.groups.put(name, servers);
    }

    public boolean removeGroup(String name) {
        return this.groups.remove(name) != null;
    }
}

