/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.common.communication;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Map;
import us.ajg0702.queue.api.communication.ComResponse;
import us.ajg0702.queue.api.players.AdaptedPlayer;
import us.ajg0702.queue.common.QueueMain;
import us.ajg0702.queue.common.communication.MessageHandler;
import us.ajg0702.queue.common.communication.handlers.AckHandler;
import us.ajg0702.queue.common.communication.handlers.EstimatedTimeHandler;
import us.ajg0702.queue.common.communication.handlers.InQueueHandler;
import us.ajg0702.queue.common.communication.handlers.LeaveQueueHandler;
import us.ajg0702.queue.common.communication.handlers.MassQueueHandler;
import us.ajg0702.queue.common.communication.handlers.PlayerStatusHandler;
import us.ajg0702.queue.common.communication.handlers.PositionHandler;
import us.ajg0702.queue.common.communication.handlers.PositionOfHandler;
import us.ajg0702.queue.common.communication.handlers.QueueHandler;
import us.ajg0702.queue.common.communication.handlers.QueueNameHandler;
import us.ajg0702.queue.common.communication.handlers.QueuedForHandler;
import us.ajg0702.queue.common.communication.handlers.RawQueueNameHandler;
import us.ajg0702.queue.common.communication.handlers.ServerQueueHandler;
import us.ajg0702.queue.common.communication.handlers.StatusHandler;
import us.ajg0702.queue.common.utils.MapBuilder;

public class CommunicationManager {
    private final QueueMain main;
    Map<String, MessageHandler> handlers;

    public CommunicationManager(QueueMain main) {
        this.main = main;
        this.handlers = new MapBuilder<String, MessageHandler>("ack", new AckHandler(main), "queue", new QueueHandler(main), "massqueue", new MassQueueHandler(main), "leavequeue", new LeaveQueueHandler(main), "queuename", new QueueNameHandler(main), "rawqueuename", new RawQueueNameHandler(main), "position", new PositionHandler(main), "positionof", new PositionOfHandler(main), "estimated_time", new EstimatedTimeHandler(main), "inqueue", new InQueueHandler(main), "queuedfor", new QueuedForHandler(main), "status", new StatusHandler(main), "playerstatus", new PlayerStatusHandler(main), "serverqueue", new ServerQueueHandler(main));
    }

    public void handle(AdaptedPlayer receivingPlayer, byte[] data) throws IOException {
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(data));
        String subChannel = in.readUTF();
        MessageHandler handler = this.handlers.get(subChannel);
        if (handler == null) {
            this.main.getLogger().warn("Invalid sub-channel " + subChannel);
            return;
        }
        ComResponse response = handler.handleMessage(receivingPlayer, in.readUTF());
        if (response == null) {
            return;
        }
        if (!receivingPlayer.isConnected()) {
            return;
        }
        this.main.getPlatformMethods().sendPluginMessage(receivingPlayer, this.s(response.getFrom()), this.s(response.getIdentifier()), this.s(response.getResponse()), this.s(response.getNoneMessage()));
    }

    private String s(String s) {
        return s + "";
    }
}

