/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.spigot.placeholders;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import us.ajg0702.queue.spigot.SpigotMain;
import us.ajg0702.queue.spigot.placeholders.CachedPlaceholder;
import us.ajg0702.queue.spigot.placeholders.Placeholder;
import us.ajg0702.queue.spigot.placeholders.placeholders.EstimatedTime;
import us.ajg0702.queue.spigot.placeholders.placeholders.InQueue;
import us.ajg0702.queue.spigot.placeholders.placeholders.Position;
import us.ajg0702.queue.spigot.placeholders.placeholders.PositionOf;
import us.ajg0702.queue.spigot.placeholders.placeholders.Queued;
import us.ajg0702.queue.spigot.placeholders.placeholders.QueuedFor;
import us.ajg0702.queue.spigot.placeholders.placeholders.QueuedStatus;
import us.ajg0702.queue.spigot.placeholders.placeholders.Status;
import us.ajg0702.queue.spigot.placeholders.placeholders.StatusPlayer;

public class PlaceholderExpansion
extends me.clip.placeholderapi.expansion.PlaceholderExpansion {
    private final List<Placeholder> placeholders = new ArrayList<Placeholder>();
    private final SpigotMain plugin;
    Map<String, CachedPlaceholder> placeholderCache = new HashMap<String, CachedPlaceholder>();

    public PlaceholderExpansion(SpigotMain plugin) {
        this.plugin = plugin;
        this.placeholders.add(new EstimatedTime(plugin));
        this.placeholders.add(new InQueue(plugin));
        this.placeholders.add(new Position(plugin));
        this.placeholders.add(new PositionOf(plugin));
        this.placeholders.add(new Queued(plugin));
        this.placeholders.add(new QueuedFor(plugin));
        this.placeholders.add(new StatusPlayer(plugin));
        this.placeholders.add(new Status(plugin));
        this.placeholders.add(new QueuedStatus(plugin));
    }

    public String onRequest(OfflinePlayer p, @NotNull String params) {
        if (p == null || !p.isOnline()) {
            return "No player";
        }
        CachedPlaceholder cachedPlaceholder = this.placeholderCache.computeIfAbsent(params, s -> {
            for (Placeholder placeholder : this.placeholders) {
                Matcher matcher = placeholder.getPattern().matcher(params);
                if (!matcher.matches()) continue;
                return new CachedPlaceholder(matcher, placeholder);
            }
            return null;
        });
        if (cachedPlaceholder == null) {
            return null;
        }
        return cachedPlaceholder.getPlaceholder().parse(cachedPlaceholder.getMatcher(), p);
    }

    @NotNull
    public String getIdentifier() {
        return "ajqueue";
    }

    @NotNull
    public String getAuthor() {
        return "ajgeiss0702";
    }

    @NotNull
    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    public boolean persist() {
        return true;
    }

    public boolean canRegister() {
        return true;
    }

    public void cleanCache(Player player) {
        this.placeholders.forEach(p -> p.cleanCache(player));
    }

    public List<Placeholder> getPlaceholderImplementations() {
        return this.placeholders;
    }
}

