/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.spigot.placeholders.placeholders;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import us.ajg0702.queue.api.spigot.AjQueueSpigotAPI;
import us.ajg0702.queue.api.spigot.MessagedResponse;
import us.ajg0702.queue.spigot.SpigotMain;
import us.ajg0702.queue.spigot.placeholders.Placeholder;
import us.ajg0702.queue.spigot.placeholders.RefetchablePlaceholder;

public class QueuedStatus
extends Placeholder
implements RefetchablePlaceholder {
    private final Map<UUID, String> cache = new ConcurrentHashMap<UUID, String>();
    private final Map<UUID, Long> lastFetch = new ConcurrentHashMap<UUID, Long>();

    public QueuedStatus(SpigotMain plugin) {
        super(plugin);
    }

    @Override
    public String getRegex() {
        return "queued_status";
    }

    @Override
    public String parse(Matcher matcher, OfflinePlayer p) {
        UUID key = p.getUniqueId();
        if (!p.isOnline()) {
            return "You aren't online!?!";
        }
        if (System.currentTimeMillis() - this.lastFetch.getOrDefault(key, 0L) > 3000L) {
            this.refetch(p, key);
        }
        return this.cache.getOrDefault(key, "...");
    }

    @Override
    public void cleanCache(Player player) {
        this.cache.entrySet().removeIf(entry -> ((UUID)entry.getKey()).equals(player.getUniqueId()));
        this.lastFetch.entrySet().removeIf(entry -> ((UUID)entry.getKey()).equals(player.getUniqueId()));
    }

    @Override
    public void refetch(OfflinePlayer p) {
        List keys = this.cache.keySet().stream().filter(key -> key.equals(p.getUniqueId())).collect(Collectors.toList());
        for (UUID uuid : keys) {
            this.refetch(p, uuid);
        }
    }

    public void refetch(OfflinePlayer p, UUID key) {
        this.lastFetch.put(key, System.currentTimeMillis());
        this.plugin.getScheduler().runTaskAsynchronously(() -> {
            if (!p.isOnline()) {
                return;
            }
            try {
                MessagedResponse<String> queueNameResponse = AjQueueSpigotAPI.getInstance().getRawQueueName(p.getUniqueId()).get(30L, TimeUnit.SECONDS);
                String queueName = queueNameResponse.getResponse();
                if (queueName == null) {
                    this.cache.put(p.getUniqueId(), queueNameResponse.getEither());
                    return;
                }
                String queueStatusResponse = AjQueueSpigotAPI.getInstance().getServerStatusString(queueName, p.getUniqueId()).get(30L, TimeUnit.SECONDS);
                this.cache.put(p.getUniqueId(), queueStatusResponse);
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalArgumentException | TimeoutException exception) {
                // empty catch block
            }
        });
    }
}

