/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.common;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import us.ajg0702.queue.common.QueueMain;
import us.ajg0702.queue.common.utils.QueueThreadFactory;

public class TaskManager {
    final ScheduledExecutorService executor = Executors.newScheduledThreadPool(1, new QueueThreadFactory("GENERIC"));
    final ScheduledExecutorService updateExecutor = Executors.newScheduledThreadPool(1, new QueueThreadFactory("UPDATE-EXECUTOR"));
    final ExecutorService serversUpdateExecutor = Executors.newCachedThreadPool(new QueueThreadFactory("SERVER-UPDATE"));
    final QueueMain main;
    ScheduledFuture<?> sendTask;
    ScheduledFuture<?> updateTask;
    ScheduledFuture<?> messageTask;
    ScheduledFuture<?> actionBarTask;
    ScheduledFuture<?> titleTask;
    ScheduledFuture<?> queueEventTask;
    ScheduledFuture<?> reloadServerTask;

    public TaskManager(QueueMain main) {
        this.main = main;
    }

    public void shutdown() {
        this.executor.shutdown();
        this.updateExecutor.shutdown();
        this.serversUpdateExecutor.shutdown();
    }

    public ExecutorService getServersUpdateExecutor() {
        return this.serversUpdateExecutor;
    }

    public String taskStatus() {
        List<ScheduledFuture> tasks = Arrays.asList(this.sendTask, this.updateTask, this.messageTask, this.actionBarTask, this.titleTask, this.queueEventTask, this.reloadServerTask);
        StringBuilder sb = new StringBuilder();
        for (ScheduledFuture task : tasks) {
            sb.append(task == null ? "null" : (task.isDone() ? "canceled/done" : "running"));
            sb.append("\n");
        }
        return sb.toString();
    }

    public void rescheduleTasks() {
        this.cancelTasks();
        this.sendTask = this.scheduleAtFixedRate(this.main.getQueueManager()::sendPlayers, (long)(this.main.getConfig().getDouble("wait-time") * 1000.0), TimeUnit.MILLISECONDS);
        this.updateTask = this.scheduleAtFixedRate(this.updateExecutor, this.main.getQueueManager()::updateServers, 500L, (long)(Math.max(this.main.getTimeBetweenPlayers() / 2.0, this.main.getConfig().getDouble("minimum-ping-time")) * 1000.0), TimeUnit.MILLISECONDS);
        int messageTime = this.main.getConfig().getInt("message-time");
        if (messageTime > 0) {
            this.messageTask = this.scheduleAtFixedRate(this.main.getQueueManager()::sendMessages, messageTime, TimeUnit.SECONDS);
        }
        this.actionBarTask = this.scheduleAtFixedRate(this.main.getQueueManager()::sendActionBars, 1500L, TimeUnit.MILLISECONDS);
        this.titleTask = this.scheduleAtFixedRate(this.main.getQueueManager()::sendTitles, 1500L, TimeUnit.MILLISECONDS);
        this.queueEventTask = this.scheduleAtFixedRate(this.main.getQueueManager()::sendQueueEvents, 1500L, TimeUnit.MILLISECONDS);
        if (this.main.getConfig().getInt("reload-servers-interval") > 0) {
            this.reloadServerTask = this.scheduleAtFixedRate(this.main.getQueueManager()::reloadServers, this.main.getConfig().getInt("reload-servers-interval").intValue(), TimeUnit.SECONDS);
        }
    }

    public void cancelTasks() {
        if (this.sendTask != null && !this.sendTask.isCancelled()) {
            this.sendTask.cancel(true);
        }
        if (this.updateTask != null && !this.updateTask.isCancelled()) {
            this.updateTask.cancel(true);
        }
        if (this.messageTask != null && !this.messageTask.isCancelled()) {
            this.messageTask.cancel(true);
        }
        if (this.actionBarTask != null && !this.actionBarTask.isCancelled()) {
            this.actionBarTask.cancel(true);
        }
        if (this.titleTask != null && !this.titleTask.isCancelled()) {
            this.titleTask.cancel(true);
        }
        if (this.queueEventTask != null && !this.queueEventTask.isCancelled()) {
            this.queueEventTask.cancel(true);
        }
        if (this.reloadServerTask != null && !this.reloadServerTask.isCancelled()) {
            this.reloadServerTask.cancel(true);
            this.reloadServerTask = null;
        }
    }

    private ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long period, TimeUnit unit) {
        return this.scheduleAtFixedRate(this.executor, command, 0L, period, unit);
    }

    public ScheduledFuture<?> runLater(Runnable runnable, long delay, TimeUnit unit) {
        return this.executor.schedule(runnable, delay, unit);
    }

    public Future<?> runNow(Runnable runnable) {
        return this.executor.submit(runnable);
    }

    private ScheduledFuture<?> scheduleAtFixedRate(ScheduledExecutorService executor, Runnable command, long initialDelay, long period, TimeUnit unit) {
        return executor.scheduleAtFixedRate(() -> {
            try {
                command.run();
            }
            catch (Exception e) {
                System.out.println("An error ocurred while running an ajQueue task");
                e.printStackTrace();
            }
        }, initialDelay, period, unit);
    }
}

