/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.commands.commands.leavequeue;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import us.ajg0702.queue.api.commands.ICommandSender;
import us.ajg0702.queue.api.commands.ISubCommand;
import us.ajg0702.queue.api.players.AdaptedPlayer;
import us.ajg0702.queue.api.players.QueuePlayer;
import us.ajg0702.queue.api.queues.QueueServer;
import us.ajg0702.queue.commands.BaseCommand;
import us.ajg0702.queue.common.QueueMain;
import us.ajg0702.queue.libs.utils.common.Messages;

public class LeaveCommand
extends BaseCommand {
    private final QueueMain main;

    public LeaveCommand(QueueMain main) {
        this.main = main;
    }

    @Override
    public String getName() {
        return "leavequeue";
    }

    @Override
    public ImmutableList<String> getAliases() {
        return ImmutableList.of((Object)"leaveq");
    }

    @Override
    public ImmutableList<ISubCommand> getSubCommands() {
        return ImmutableList.of();
    }

    @Override
    public String getPermission() {
        return null;
    }

    @Override
    public Messages getMessages() {
        return this.main.getMessages();
    }

    @Override
    public void execute(ICommandSender sender, String[] args) {
        if (!sender.isPlayer()) {
            sender.sendMessage(this.getMessages().getComponent("errors.player-only", new String[0]));
            return;
        }
        AdaptedPlayer player = this.main.getPlatformMethods().senderToPlayer(sender);
        ImmutableList<QueueServer> servers = this.main.getQueueManager().getPlayerQueues(player);
        if (servers.size() == 0) {
            sender.sendMessage(this.getMessages().getComponent("commands.leave.no-queues", new String[0]));
            return;
        }
        if (servers.size() == 1) {
            ((QueueServer)servers.get(0)).removePlayer(player);
            sender.sendMessage(this.getMessages().getComponent("commands.leave-queue", "SERVER:" + ((QueueServer)servers.get(0)).getAlias()));
            return;
        }
        if (args.length <= 0) {
            sender.sendMessage(this.getMessages().getComponent("commands.leave.more-args", "QUEUES:" + this.getQueueList((List<QueueServer>)servers)));
            return;
        }
        String leaving = args[0];
        QueueServer leavingServer = this.main.getQueueManager().findServer(leaving);
        if (leavingServer == null) {
            sender.sendMessage(this.getMessages().getComponent("commands.leave.not-queued", "QUEUES:" + this.getQueueList((List<QueueServer>)servers)));
            return;
        }
        QueuePlayer queuePlayer = leavingServer.findPlayer(player);
        if (queuePlayer == null) {
            sender.sendMessage(this.getMessages().getComponent("commands.leave.not-queued", "QUEUES:" + this.getQueueList((List<QueueServer>)servers)));
            return;
        }
        leavingServer.removePlayer(queuePlayer);
        sender.sendMessage(this.getMessages().getComponent("commands.leave-queue", "SERVER:" + leavingServer.getAlias()));
    }

    private String getQueueList(List<QueueServer> servers) {
        StringBuilder queueList = new StringBuilder();
        for (QueueServer server : servers) {
            queueList.append(this.getMessages().getString("commands.leave.queues-list-format", new String[0]).replaceAll("\\{NAME}", server.getName()));
        }
        if (queueList.length() > 2) {
            queueList = new StringBuilder(queueList.substring(0, queueList.length() - 2));
        }
        return queueList.toString();
    }

    @Override
    public List<String> autoComplete(ICommandSender sender, String[] args) {
        if (!sender.isPlayer() || args.length > 1) {
            return Collections.emptyList();
        }
        ImmutableList<QueuePlayer> servers = this.main.getQueueManager().findPlayerInQueues(this.main.getPlatformMethods().senderToPlayer(sender));
        ArrayList<String> serverNames = new ArrayList<String>();
        for (QueuePlayer queuePlayer : servers) {
            serverNames.add(queuePlayer.getQueueServer().getName());
        }
        return this.filterCompletion(serverNames, args[0]);
    }
}

