/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.commands.commands.manage.debug;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import us.ajg0702.queue.api.commands.ICommandSender;
import us.ajg0702.queue.api.server.AdaptedServer;
import us.ajg0702.queue.commands.SubCommand;
import us.ajg0702.queue.common.QueueMain;
import us.ajg0702.queue.libs.utils.common.Messages;

public class Whitelist
extends SubCommand {
    final QueueMain main;

    public Whitelist(QueueMain main) {
        this.main = main;
    }

    @Override
    public String getName() {
        return "whitelist";
    }

    @Override
    public ImmutableList<String> getAliases() {
        return ImmutableList.of();
    }

    @Override
    public String getPermission() {
        return null;
    }

    @Override
    public boolean showInTabComplete() {
        return false;
    }

    @Override
    public Messages getMessages() {
        return this.main.getMessages();
    }

    @Override
    public void execute(ICommandSender sender, String[] args) {
        if (!this.checkPermission(sender)) {
            return;
        }
        if (args.length < 1) {
            sender.sendMessage(this.main.getMessages().toComponent("<red>Not enough args!"));
            return;
        }
        AdaptedServer server = this.main.getPlatformMethods().getServer(args[0]);
        if (server == null) {
            sender.sendMessage(this.main.getMessages().toComponent("<red>Server not found"));
            return;
        }
        sender.sendMessage(this.main.getMessages().toComponent("<green>Yours: " + this.main.getPlatformMethods().senderToPlayer(sender).getUniqueId().toString()));
        server.getWhitelistedPlayers().forEach(uuid -> sender.sendMessage(this.main.getMessages().toComponent("<yellow>" + uuid)));
    }

    @Override
    public List<String> autoComplete(ICommandSender sender, String[] args) {
        return new ArrayList<String>();
    }
}

