/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.common;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import us.ajg0702.queue.api.players.QueuePlayer;
import us.ajg0702.queue.api.queueholders.QueueHolder;
import us.ajg0702.queue.api.queues.QueueServer;

public class DefaultQueueHolder
extends QueueHolder {
    List<QueuePlayer> queue = new CopyOnWriteArrayList<QueuePlayer>();

    public DefaultQueueHolder(QueueServer queueServer) {
        super(queueServer);
    }

    @Override
    public String getIdentifier() {
        return "default";
    }

    @Override
    public void addPlayer(QueuePlayer player) {
        this.queue.add(player);
    }

    @Override
    public void addPlayer(QueuePlayer player, int position) {
        this.queue.add(position, player);
    }

    @Override
    public void removePlayer(QueuePlayer player) {
        this.queue.remove(player);
    }

    @Override
    public QueuePlayer findPlayer(UUID uuid) {
        for (QueuePlayer queuePlayer : this.queue) {
            if (!queuePlayer.getUniqueId().toString().equals(uuid.toString())) continue;
            return queuePlayer;
        }
        return null;
    }

    @Override
    public QueuePlayer findPlayer(String name) {
        for (QueuePlayer queuePlayer : this.queue) {
            if (!queuePlayer.getName().equalsIgnoreCase(name)) continue;
            return queuePlayer;
        }
        return null;
    }

    @Override
    public int getQueueSize() {
        return this.queue.size();
    }

    @Override
    public int getPosition(QueuePlayer player) {
        return this.queue.indexOf(player) + 1;
    }

    @Override
    public List<QueuePlayer> getAllPlayers() {
        return ImmutableList.copyOf(this.queue);
    }
}

