/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.common.queues.balancers;

import com.google.common.collect.ImmutableList;
import org.jetbrains.annotations.Nullable;
import us.ajg0702.queue.api.players.AdaptedPlayer;
import us.ajg0702.queue.api.queues.Balancer;
import us.ajg0702.queue.api.queues.QueueServer;
import us.ajg0702.queue.api.server.AdaptedServer;
import us.ajg0702.queue.common.QueueMain;
import us.ajg0702.queue.libs.utils.common.GenUtils;

public class DefaultBalancer
implements Balancer {
    private final QueueServer server;
    private final QueueMain main;

    public DefaultBalancer(QueueServer server, QueueMain main) {
        this.server = server;
        this.main = main;
    }

    @Override
    public AdaptedServer getIdealServer(@Nullable AdaptedPlayer player) {
        AdaptedServer alreadyConnected = player == null ? null : player.getCurrentServer();
        ImmutableList<AdaptedServer> servers = this.server.getServers();
        AdaptedServer selected = null;
        int selectednum = 0;
        if (servers.size() == 1) {
            selected = (AdaptedServer)servers.get(0);
        } else {
            for (AdaptedServer sv : servers) {
                if (!sv.isOnline() || sv.equals(alreadyConnected)) continue;
                int online = sv.getPlayerCount();
                if (selected == null) {
                    selected = sv;
                    selectednum = online;
                    continue;
                }
                if (!selected.isJoinable(player) && sv.isJoinable(player)) {
                    selected = sv;
                    selectednum = online;
                    continue;
                }
                if (selectednum <= online || !sv.isJoinable(player)) continue;
                selected = sv;
                selectednum = online;
            }
        }
        if (selected == null && servers.size() > 0) {
            selected = (AdaptedServer)servers.get(0);
        }
        if (selected == null) {
            this.main.getLogger().warning("Unable to find ideal server, using random server from group.");
            int r = GenUtils.randomInt(0, this.server.getServers().size() - 1);
            selected = (AdaptedServer)this.server.getServers().get(r);
        }
        return selected;
    }
}

