/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.libs.utils.common;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.Nullable;
import us.ajg0702.queue.libs.utils.common.UtilsLogger;

public class UpdateManager {
    private final ScheduledExecutorService updateExecutor = Executors.newScheduledThreadPool(1);
    private final UtilsLogger logger;
    private final String currentVersion;
    private String jarName;
    private final String pluginName;
    private final File pluginsFolder;
    private final String downloadCommand;
    private String updateToken;
    private String latestVersion;
    boolean updateAvailable = false;
    boolean ready = false;
    boolean alreadyDownloaded = false;
    private boolean isPremium = false;

    public UpdateManager(UtilsLogger logger, String currentVersion, String jarName, String pluginName, @Nullable String updateToken, File pluginsFolder, String downloadCommand) {
        this.logger = logger;
        this.jarName = jarName;
        this.pluginName = pluginName;
        this.pluginsFolder = pluginsFolder;
        this.downloadCommand = downloadCommand;
        this.updateToken = updateToken;
        this.currentVersion = currentVersion.contains("-") ? currentVersion.split("-")[0] : currentVersion;
        this.updateExecutor.scheduleAtFixedRate(() -> {
            try {
                this.check();
            }
            catch (Exception e) {
                logger.warn("Unable to check for update: " + e.getMessage());
            }
        }, 2L, 1800L, TimeUnit.SECONDS);
    }

    public void setUpdateToken(String newToken) {
        this.updateToken = newToken;
    }

    public void check() throws IOException {
        URL url = new URL("https://plugin-updates.ajg0702.us/plugins/" + this.pluginName + ".json");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.addRequestProperty("User-Agent", this.jarName + "/" + this.currentVersion);
        if (connection.getResponseCode() == 404) {
            throw new IllegalArgumentException("Plugin name " + this.pluginName + " does not appear to exist on the server!");
        }
        if (connection.getResponseCode() != 200) {
            throw new IllegalStateException("Response code was " + connection.getResponseCode());
        }
        InputStream inputStream = connection.getInputStream();
        InputStreamReader reader = new InputStreamReader(inputStream);
        JsonObject json = new JsonParser().parse((Reader)reader).getAsJsonObject();
        this.latestVersion = json.get("latest").getAsString();
        this.isPremium = json.get("premium").getAsBoolean();
        if (this.latestVersion.contains("-")) {
            this.latestVersion = this.latestVersion.split("-")[0];
        }
        if (this.latestVersion.isEmpty()) {
            throw new IllegalStateException("Latest version is empty!");
        }
        String[] parts = this.latestVersion.split("\\.");
        String[] currentParts = this.currentVersion.split("\\.");
        int i = 0;
        for (String part : parts) {
            int currentVersion;
            if (i >= currentParts.length) break;
            int newVersion = Integer.parseInt(part);
            if (newVersion > (currentVersion = Integer.parseInt(currentParts[i]))) {
                if (i != 0) {
                    int currentVersionLast;
                    int newVersionLast = Integer.parseInt(parts[i - 1]);
                    if (newVersionLast >= (currentVersionLast = Integer.parseInt(currentParts[i - 1]))) {
                        this.updateAvailable = true;
                        break;
                    }
                } else {
                    this.updateAvailable = true;
                    break;
                }
            }
            ++i;
        }
        if (this.updateAvailable && !this.ready) {
            this.logger.info("An update is available! (" + this.latestVersion + ") Run /" + this.downloadCommand + " to download it!");
        } else if (!this.ready) {
            this.logger.info("You are up to date! (" + this.latestVersion + ")");
        }
        this.ready = true;
    }

    public boolean isUpdateAvailable() {
        return this.updateAvailable;
    }

    public boolean isAlreadyDownloaded() {
        return this.alreadyDownloaded;
    }

    public DownloadCompleteStatus downloadUpdate() {
        if (!this.updateAvailable) {
            try {
                this.check();
            }
            catch (Exception e) {
                this.logger.warn("Unable to check for update: " + e.getMessage());
                return DownloadCompleteStatus.ERROR_WHILE_CHECKING;
            }
            if (!this.updateAvailable) {
                this.logger.warn("No update is available!");
                return DownloadCompleteStatus.ERROR_NO_UPDATE_AVAILABLE;
            }
        }
        if (this.isPremium && (this.updateToken == null || this.updateToken.isEmpty())) {
            return DownloadCompleteStatus.ERROR_MISSING_UPDATE_TOKEN;
        }
        if (this.alreadyDownloaded) {
            return DownloadCompleteStatus.ERROR_ALREADY_DOWNLOADED;
        }
        List<String> possibleNames = Arrays.asList(this.jarName + "-" + this.currentVersion, this.jarName.toLowerCase(Locale.ROOT) + "-" + this.currentVersion, this.jarName.toLowerCase(Locale.ROOT), this.jarName, this.jarName + "-" + this.currentVersion + " (1)", this.jarName + "-" + this.currentVersion + " (2)", this.jarName + "-" + this.currentVersion + " (3)");
        File oldJar = null;
        for (String possibleName : possibleNames) {
            File file = new File(this.pluginsFolder, possibleName + ".jar");
            if (!file.exists()) continue;
            oldJar = file;
            break;
        }
        try {
            URL url = new URL("https://plugin-updates.ajg0702.us/jars/" + (this.isPremium ? "premium" : "free") + "/" + this.jarName + "-" + this.latestVersion + ".jar");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.addRequestProperty("User-Agent", this.jarName + "/" + this.currentVersion);
            if (this.isPremium && this.updateToken != null && !this.updateToken.isEmpty()) {
                connection.addRequestProperty("Authorization", "Update-Token " + this.updateToken);
            }
            connection.setInstanceFollowRedirects(true);
            if (connection.getResponseCode() == 401) {
                return DownloadCompleteStatus.ERROR_INVALID_UPDATE_TOKEN;
            }
            if (connection.getResponseCode() != 200) {
                throw new IllegalStateException("Bad response code while downloading: " + connection.getResponseCode() + " " + connection.getResponseMessage());
            }
            ReadableByteChannel readableByteChannel = Channels.newChannel(connection.getInputStream());
            File out = new File(this.pluginsFolder, this.jarName + "-" + this.latestVersion + ".jar");
            this.logger.info("Downloading to " + out.getAbsolutePath());
            FileOutputStream fileOutputStream = new FileOutputStream(out);
            fileOutputStream.getChannel().transferFrom(readableByteChannel, 0L, Long.MAX_VALUE);
            fileOutputStream.close();
            this.logger.info("Download complete!");
            this.updateAvailable = false;
            this.alreadyDownloaded = true;
            if (!oldJar.delete()) {
                this.logger.warning("Unable to delete the old jar! You should delete it yourself before restarting.");
                return DownloadCompleteStatus.WARNING_COULD_NOT_DELETE_OLD_JAR;
            }
            return DownloadCompleteStatus.SUCCESS;
        }
        catch (Exception e) {
            this.logger.warn("Error while downloading jar: " + e.getMessage());
            return DownloadCompleteStatus.ERROR_WHILE_DOWNLOADING;
        }
    }

    public static enum DownloadCompleteStatus {
        SUCCESS,
        WARNING_COULD_NOT_DELETE_OLD_JAR,
        ERROR_NO_UPDATE_AVAILABLE,
        ERROR_WHILE_CHECKING,
        ERROR_ALREADY_DOWNLOADED,
        ERROR_JAR_NOT_FOUND,
        ERROR_WHILE_DOWNLOADING,
        ERROR_MISSING_UPDATE_TOKEN,
        ERROR_INVALID_UPDATE_TOKEN;

    }
}

