/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.platforms.bungeecord;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.platform.bungeecord.BungeeAudiences;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.bungeecord.BungeeComponentSerializer;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.PlayerDisconnectEvent;
import net.md_5.bungee.api.event.PluginMessageEvent;
import net.md_5.bungee.api.event.PostLoginEvent;
import net.md_5.bungee.api.event.ServerConnectEvent;
import net.md_5.bungee.api.event.ServerKickEvent;
import net.md_5.bungee.api.event.ServerSwitchEvent;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.event.EventHandler;
import org.checkerframework.checker.nullness.qual.NonNull;
import us.ajg0702.queue.api.Implementation;
import us.ajg0702.queue.api.commands.IBaseCommand;
import us.ajg0702.queue.api.server.AdaptedServer;
import us.ajg0702.queue.commands.BaseCommand;
import us.ajg0702.queue.commands.commands.leavequeue.LeaveCommand;
import us.ajg0702.queue.commands.commands.listqueues.ListCommand;
import us.ajg0702.queue.commands.commands.manage.ManageCommand;
import us.ajg0702.queue.commands.commands.queue.QueueCommand;
import us.ajg0702.queue.commands.commands.send.SendAlias;
import us.ajg0702.queue.common.QueueMain;
import us.ajg0702.queue.libs.bstats.bungeecord.Metrics;
import us.ajg0702.queue.libs.bstats.charts.SimplePie;
import us.ajg0702.queue.platforms.bungeecord.BungeeLogger;
import us.ajg0702.queue.platforms.bungeecord.BungeeMethods;
import us.ajg0702.queue.platforms.bungeecord.commands.BungeeCommand;
import us.ajg0702.queue.platforms.bungeecord.players.BungeePlayer;
import us.ajg0702.queue.platforms.bungeecord.server.BungeeServer;

public class BungeeQueue
extends Plugin
implements Listener,
Implementation {
    private QueueMain main;
    List<IBaseCommand> commands;
    Map<String, BungeeCommand> commandMap;
    private static BungeeAudiences adventure;

    public void onEnable() {
        BungeeLogger logger = new BungeeLogger(this.getLogger());
        File dataFolder = this.getDataFolder();
        this.commandMap = new HashMap<String, BungeeCommand>();
        adventure = BungeeAudiences.create(this);
        this.main = new QueueMain(this, logger, new BungeeMethods(this, this.getProxy(), logger), dataFolder);
        this.getProxy().registerChannel("ajqueue:tospigot");
        this.getProxy().registerChannel("ajqueue:toproxy");
        this.commands = new ArrayList<BaseCommand>(Arrays.asList(new QueueCommand(this.main), new LeaveCommand(this.main), new ListCommand(this.main), new ManageCommand(this.main)));
        if (this.main.getConfig().getBoolean("enable-send-alias")) {
            this.commands.add(new SendAlias(this.main));
        }
        for (IBaseCommand command : this.commands) {
            this.registerCommand(command);
        }
        this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)this);
        Metrics metrics = new Metrics(this, 7404);
        metrics.addCustomChart(new SimplePie("premium", () -> String.valueOf(this.main.getLogic().isPremium())));
        metrics.addCustomChart(new SimplePie("implementation", () -> this.main.getPlatformMethods().getImplementationName()));
    }

    public static @NonNull BungeeAudiences adventure() {
        if (adventure == null) {
            throw new IllegalStateException("Cannot retrieve audience provider. Not loaded yet.");
        }
        return adventure;
    }

    public void onDisable() {
        this.main.shutdown();
        if (adventure != null) {
            adventure.close();
            adventure = null;
        }
    }

    @EventHandler
    public void onPluginMessage(PluginMessageEvent e) {
        if (e.getTag().equals("ajqueue:tospigot")) {
            e.setCancelled(true);
            return;
        }
        if (!e.getTag().equals("ajqueue:toproxy")) {
            return;
        }
        e.setCancelled(true);
        if (!(e.getReceiver() instanceof ProxiedPlayer)) {
            return;
        }
        ProxyServer.getInstance().getScheduler().runAsync((Plugin)this, () -> this.main.getEventHandler().handleMessage(new BungeePlayer((ProxiedPlayer)e.getReceiver()), e.getData()));
    }

    @EventHandler
    public void onJoin(PostLoginEvent e) {
        this.main.getEventHandler().onPlayerJoin(new BungeePlayer(e.getPlayer()));
    }

    @EventHandler
    public void onServerSwitch(ServerSwitchEvent e) {
        ProxyServer.getInstance().getScheduler().runAsync((Plugin)this, () -> this.main.getEventHandler().onPlayerJoinServer(new BungeePlayer(e.getPlayer())));
    }

    @EventHandler
    public void onLeave(PlayerDisconnectEvent e) {
        ProxyServer.getInstance().getScheduler().runAsync((Plugin)this, () -> this.main.getEventHandler().onPlayerLeave(new BungeePlayer(e.getPlayer())));
    }

    @EventHandler
    public void onKick(ServerKickEvent e) {
        if (!e.getPlayer().isConnected()) {
            return;
        }
        if (e.getPlayer().getServer() == null) {
            return;
        }
        ProxyServer.getInstance().getScheduler().runAsync((Plugin)this, () -> {
            Component reason = BungeeComponentSerializer.get().deserialize(e.getKickReasonComponent());
            this.main.getEventHandler().onServerKick(new BungeePlayer(e.getPlayer()), new BungeeServer(e.getKickedFrom()), reason, false);
        });
    }

    @EventHandler
    public void onServerConnect(ServerConnectEvent e) {
        AdaptedServer newServer = this.main.getEventHandler().changeTargetServer(new BungeePlayer(e.getPlayer()), new BungeeServer(e.getTarget()));
        if (newServer == null) {
            return;
        }
        e.setTarget((ServerInfo)newServer.getHandle());
    }

    @Override
    public void unregisterCommand(String name) {
        BungeeCommand bungeeCommand = this.commandMap.get(name);
        if (bungeeCommand == null) {
            return;
        }
        this.getProxy().getPluginManager().unregisterCommand((Command)bungeeCommand);
        this.commandMap.remove(name);
    }

    @Override
    public void registerCommand(IBaseCommand command) {
        BungeeCommand bungeeCommand = new BungeeCommand((BaseCommand)command);
        this.commandMap.put(command.getName(), bungeeCommand);
        this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)bungeeCommand);
    }

    public QueueMain getMain() {
        return this.main;
    }
}

