/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.platforms.velocity;

import com.google.inject.Inject;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.command.CommandManager;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.DisconnectEvent;
import com.velocitypowered.api.event.connection.PluginMessageEvent;
import com.velocitypowered.api.event.player.KickedFromServerEvent;
import com.velocitypowered.api.event.player.ServerPostConnectEvent;
import com.velocitypowered.api.event.player.ServerPreConnectEvent;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import com.velocitypowered.api.proxy.messages.MinecraftChannelIdentifier;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.WeakHashMap;
import net.kyori.adventure.text.Component;
import org.slf4j.Logger;
import us.ajg0702.queue.api.Implementation;
import us.ajg0702.queue.api.commands.IBaseCommand;
import us.ajg0702.queue.api.server.AdaptedServer;
import us.ajg0702.queue.commands.BaseCommand;
import us.ajg0702.queue.commands.commands.leavequeue.LeaveCommand;
import us.ajg0702.queue.commands.commands.listqueues.ListCommand;
import us.ajg0702.queue.commands.commands.manage.ManageCommand;
import us.ajg0702.queue.commands.commands.queue.QueueCommand;
import us.ajg0702.queue.commands.commands.send.SendAlias;
import us.ajg0702.queue.common.QueueMain;
import us.ajg0702.queue.libs.bstats.charts.SimplePie;
import us.ajg0702.queue.libs.bstats.velocity.Metrics;
import us.ajg0702.queue.platforms.velocity.VelocityLogger;
import us.ajg0702.queue.platforms.velocity.VelocityMethods;
import us.ajg0702.queue.platforms.velocity.commands.VelocityCommand;
import us.ajg0702.queue.platforms.velocity.players.VelocityPlayer;
import us.ajg0702.queue.platforms.velocity.server.VelocityServer;

@Plugin(id="ajqueue", name="ajQueue", version="2.7.0-b192", url="https://ajg0702.us", description="Queue for servers", authors={"ajgeiss0702"})
public class VelocityQueue
implements Implementation {
    final ProxyServer proxyServer;
    final VelocityLogger logger;
    QueueMain main;
    final File dataFolder;
    private final Metrics.Factory metricsFactory;
    List<IBaseCommand> commands;
    CommandManager commandManager;
    private final WeakHashMap<Player, RegisteredServer> changedTargetPlayers = new WeakHashMap();

    @Inject
    public VelocityQueue(ProxyServer proxyServer, Logger logger, @DataDirectory Path dataFolder, Metrics.Factory metricsFactory) {
        this.proxyServer = proxyServer;
        this.logger = new VelocityLogger(logger);
        this.dataFolder = dataFolder.toFile();
        this.metricsFactory = metricsFactory;
    }

    @Subscribe
    public void onProxyInit(ProxyInitializeEvent e) {
        this.commandManager = this.proxyServer.getCommandManager();
        this.main = new QueueMain(this, this.logger, new VelocityMethods(this, this.proxyServer, this.logger), this.dataFolder);
        if (this.main.getConfig().getBoolean("enable-server-command")) {
            this.commandManager.unregister("server");
        }
        this.commands = new ArrayList<BaseCommand>(Arrays.asList(new QueueCommand(this.main), new LeaveCommand(this.main), new ListCommand(this.main), new ManageCommand(this.main)));
        if (this.main.getConfig().getBoolean("enable-send-alias")) {
            this.commands.add(new SendAlias(this.main));
        }
        this.proxyServer.getChannelRegistrar().register(new ChannelIdentifier[]{MinecraftChannelIdentifier.create((String)"ajqueue", (String)"tospigot")});
        this.proxyServer.getChannelRegistrar().register(new ChannelIdentifier[]{MinecraftChannelIdentifier.from((String)"ajqueue:toproxy")});
        for (IBaseCommand command : this.commands) {
            this.registerCommand(command);
        }
        Metrics metrics = this.metricsFactory.make(this, 7404);
        metrics.addCustomChart(new SimplePie("premium", () -> String.valueOf(this.main.getLogic().isPremium())));
        metrics.addCustomChart(new SimplePie("implementation", () -> this.main.getPlatformMethods().getImplementationName()));
    }

    @Subscribe
    public void onProxyShutdown(ProxyShutdownEvent e) {
        this.main.shutdown();
    }

    @Subscribe
    public void onPluginMessage(PluginMessageEvent e) {
        if (e.getIdentifier().getId().equals("ajqueue:tospigot")) {
            e.setResult(PluginMessageEvent.ForwardResult.handled());
            return;
        }
        if (!e.getIdentifier().getId().equals("ajqueue:toproxy")) {
            return;
        }
        e.setResult(PluginMessageEvent.ForwardResult.handled());
        if (!(e.getTarget() instanceof Player)) {
            return;
        }
        this.main.getEventHandler().handleMessage(new VelocityPlayer((Player)e.getTarget()), e.getData());
    }

    @Subscribe
    public void onJoin(ServerPostConnectEvent e) {
        if (e.getPreviousServer() == null) {
            this.main.getEventHandler().onPlayerJoin(new VelocityPlayer(e.getPlayer()));
        }
        this.main.getEventHandler().onPlayerJoinServer(new VelocityPlayer(e.getPlayer()));
    }

    @Subscribe
    public void onLeave(DisconnectEvent e) {
        this.main.getEventHandler().onPlayerLeave(new VelocityPlayer(e.getPlayer()));
    }

    @Subscribe
    public void onKick(KickedFromServerEvent e) {
        if (!e.getPlayer().getCurrentServer().isPresent()) {
            if (this.changedTargetPlayers.containsKey(e.getPlayer())) {
                e.setResult(KickedFromServerEvent.RedirectPlayer.create((RegisteredServer)this.changedTargetPlayers.get(e.getPlayer())));
                this.changedTargetPlayers.remove(e.getPlayer());
            } else {
                return;
            }
        }
        Optional reasonOptional = e.getServerKickReason();
        this.main.getEventHandler().onServerKick(new VelocityPlayer(e.getPlayer()), new VelocityServer(e.getServer()), reasonOptional.orElseGet(() -> Component.text("Proxy lost connection")), e.kickedDuringServerConnect());
    }

    @Subscribe
    public void onPreConnect(ServerPreConnectEvent e) {
        RegisteredServer to = e.getResult().getServer().orElse(null);
        if (to == null) {
            return;
        }
        AdaptedServer newServer = this.main.getEventHandler().changeTargetServer(new VelocityPlayer(e.getPlayer()), new VelocityServer(to));
        if (newServer == null) {
            return;
        }
        this.changedTargetPlayers.put(e.getPlayer(), to);
        e.setResult(ServerPreConnectEvent.ServerResult.allowed((RegisteredServer)((RegisteredServer)newServer.getHandle())));
    }

    @Override
    public void unregisterCommand(String name) {
        this.commandManager.unregister(name);
    }

    @Override
    public void registerCommand(IBaseCommand command) {
        this.commandManager.register(this.commandManager.metaBuilder(command.getName()).aliases((String[])command.getAliases().toArray((Object[])new String[0])).build(), (Command)new VelocityCommand(this.main, (BaseCommand)command));
    }

    public QueueMain getMain() {
        return this.main;
    }
}

