/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.spigot.commands;

import java.util.ArrayList;
import java.util.Arrays;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.command.defaults.BukkitCommand;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import us.ajg0702.queue.api.spigot.AjQueueSpigotAPI;
import us.ajg0702.queue.libs.utils.common.Messages;
import us.ajg0702.queue.spigot.SpigotMain;

public class SpigotQueueCommand
extends BukkitCommand {
    final SpigotMain pl;

    public SpigotQueueCommand(SpigotMain pl, boolean serverAlias, boolean spigotQueueAlias) {
        super("queue");
        this.pl = pl;
        this.description = "Queue for a server";
        this.usageMessage = "/queue [player] <server>";
        ArrayList<String> aliases = new ArrayList<String>(Arrays.asList("move", "joinq", "joinqueue"));
        if (serverAlias) {
            aliases.add("server");
        }
        if (spigotQueueAlias) {
            aliases.add("spigotqueue");
        }
        this.setAliases(aliases);
    }

    public boolean execute(@NotNull CommandSender sender, @NotNull String label, @NotNull String[] args) {
        if (this.pl.checkProxyResponse(sender)) {
            return true;
        }
        Player player = null;
        if (sender instanceof Player) {
            player = (Player)sender;
        }
        if (args.length < 1) {
            return false;
        }
        String serverName = args[0];
        boolean sudo = true;
        if (args.length > 1) {
            sudo = false;
            if (!sender.hasPermission("ajqueue.send")) {
                sender.sendMessage(Messages.color("&cYou do not have permission to do this!"));
                return true;
            }
            this.pl.getLogger().info("Sending " + args[0] + " to queue '" + args[1] + "'");
            Player playerToSend = Bukkit.getPlayer((String)args[0]);
            if (playerToSend == null) {
                sender.sendMessage(Messages.color("&cCannot find that player!"));
                return true;
            }
            player = playerToSend;
            serverName = args[1];
        }
        if (player == null) {
            sender.sendMessage("I need to know what player to send!");
            return true;
        }
        if (sudo) {
            if (this.pl.getAConfig().getBoolean("send-queue-commands-in-batches")) {
                this.pl.getQueueBatch().put(player, serverName);
            } else {
                AjQueueSpigotAPI.getInstance().sudoQueue(player.getUniqueId(), serverName);
            }
        } else {
            AjQueueSpigotAPI.getInstance().addToQueue(player.getUniqueId(), serverName);
        }
        return true;
    }
}

