/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.commands.commands.listqueues;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import us.ajg0702.queue.api.commands.ICommandSender;
import us.ajg0702.queue.api.commands.ISubCommand;
import us.ajg0702.queue.api.players.AdaptedPlayer;
import us.ajg0702.queue.api.queues.QueueServer;
import us.ajg0702.queue.commands.BaseCommand;
import us.ajg0702.queue.common.QueueMain;
import us.ajg0702.queue.libs.utils.common.Messages;

public class ListCommand
extends BaseCommand {
    private final QueueMain main;

    public ListCommand(QueueMain main) {
        this.main = main;
    }

    @Override
    public String getName() {
        return "listqueues";
    }

    @Override
    public ImmutableList<String> getAliases() {
        return ImmutableList.of((Object)"listq");
    }

    @Override
    public ImmutableList<ISubCommand> getSubCommands() {
        return ImmutableList.builder().build();
    }

    @Override
    public String getPermission() {
        return "ajqueue.listqueues";
    }

    @Override
    public Messages getMessages() {
        return this.main.getMessages();
    }

    @Override
    public void execute(ICommandSender sender, String[] args) {
        if (!this.checkPermission(sender)) {
            return;
        }
        AdaptedPlayer spp = null;
        if (sender.isPlayer()) {
            spp = this.main.getPlatformMethods().senderToPlayer(sender);
        }
        sender.sendMessage(this.main.getMessages().getComponent("commands.listqueues.header", new String[0]));
        for (QueueServer s : this.main.getQueueManager().getServers()) {
            String color = "&a";
            if (!s.isOnline()) {
                color = "&c";
            } else if (!s.isJoinable(spp)) {
                color = "&e";
            }
            sender.sendMessage(this.main.getMessages().getComponent("commands.listqueues.format", "COLOR:" + Messages.color(color), "NAME:" + s.getAlias(), "COUNT:" + s.getQueue().size(), "STATUS:" + Messages.color(this.main.getMessages().getRawString("placeholders.status." + s.getStatus(spp), new String[0]))));
        }
    }

    @Override
    public List<String> autoComplete(ICommandSender sender, String[] args) {
        return Collections.emptyList();
    }
}

