/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.commands.commands.manage;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import us.ajg0702.queue.api.commands.ICommandSender;
import us.ajg0702.queue.api.players.QueuePlayer;
import us.ajg0702.queue.api.queues.QueueServer;
import us.ajg0702.queue.commands.SubCommand;
import us.ajg0702.queue.common.QueueMain;
import us.ajg0702.queue.libs.utils.common.Messages;

public class QueueList
extends SubCommand {
    final QueueMain main;

    public QueueList(QueueMain main) {
        this.main = main;
    }

    @Override
    public String getName() {
        return "list";
    }

    @Override
    public ImmutableList<String> getAliases() {
        return ImmutableList.of();
    }

    @Override
    public String getPermission() {
        return "ajqueue.manage.list";
    }

    @Override
    public Messages getMessages() {
        return this.main.getMessages();
    }

    @Override
    public void execute(ICommandSender sender, String[] args) {
        if (!this.checkPermission(sender)) {
            return;
        }
        int total = 0;
        for (QueueServer server : this.main.getQueueManager().getServers()) {
            String msg = this.getMessages().getRawString("list.format", "SERVER:" + server.getName());
            StringBuilder playerList = new StringBuilder();
            ImmutableList<QueuePlayer> players = server.getQueue();
            boolean none = true;
            for (QueuePlayer p : players) {
                playerList.append(this.getMessages().getRawString("list.playerlist", "NAME:" + p.getName()));
                none = false;
            }
            if (none) {
                playerList.append(this.getMessages().getRawString("list.none", new String[0]));
                playerList.append(", ");
            }
            msg = msg.replaceAll("\\{LIST}", playerList.toString());
            msg = Arrays.stream(msg.split("\n")).map(String::trim).map(c -> c.endsWith(",") ? c.substring(0, c.length() - 1) : c).collect(Collectors.joining("\n"));
            total += players.size();
            msg = msg.replaceAll("\\{COUNT}", players.size() + "");
            sender.sendMessage(this.main.getMessages().toComponent(msg));
        }
        sender.sendMessage(this.getMessages().getComponent("list.total", "TOTAL:" + total));
    }

    @Override
    public List<String> autoComplete(ICommandSender sender, String[] args) {
        return Collections.emptyList();
    }
}

