/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.commands.commands.manage;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import us.ajg0702.queue.api.commands.ICommandSender;
import us.ajg0702.queue.commands.SubCommand;
import us.ajg0702.queue.common.QueueMain;
import us.ajg0702.queue.libs.utils.common.Messages;
import us.ajg0702.queue.libs.utils.common.UpdateManager;

public class Update
extends SubCommand {
    final QueueMain main;

    public Update(QueueMain main) {
        this.main = main;
    }

    @Override
    public String getName() {
        return "update";
    }

    @Override
    public ImmutableList<String> getAliases() {
        return ImmutableList.of();
    }

    @Override
    public String getPermission() {
        return "ajqueue.manage.update";
    }

    @Override
    public Messages getMessages() {
        return this.main.getMessages();
    }

    @Override
    public void execute(ICommandSender sender, String[] args) {
        if (!this.checkPermission(sender)) {
            return;
        }
        UpdateManager updater = this.main.getUpdateManager();
        if (updater == null) {
            sender.sendMessage(this.getMessages().getComponent("updater.disabled", new String[0]));
            return;
        }
        if (updater.isAlreadyDownloaded()) {
            sender.sendMessage(this.getMessages().getComponent("updater.already-downloaded", new String[0]));
            return;
        }
        if (!updater.isUpdateAvailable()) {
            sender.sendMessage(this.getMessages().getComponent("updater.no-update", new String[0]));
            return;
        }
        AtomicBoolean done = new AtomicBoolean(false);
        this.main.getTaskManager().runNow(() -> {
            try {
                UpdateManager.DownloadCompleteStatus result = updater.downloadUpdate();
                done.set(true);
                switch (result) {
                    case SUCCESS: {
                        sender.sendMessage(this.getMessages().getComponent("updater.success", new String[0]));
                        break;
                    }
                    case WARNING_COULD_NOT_DELETE_OLD_JAR: {
                        sender.sendMessage(this.getMessages().getComponent("updater.warnings.could-not-delete-old-jar", new String[0]));
                        break;
                    }
                    case ERROR_NO_UPDATE_AVAILABLE: {
                        sender.sendMessage(this.getMessages().getComponent("updater.no-update", new String[0]));
                        break;
                    }
                    case ERROR_WHILE_CHECKING: {
                        sender.sendMessage(this.getMessages().getComponent("updater.errors.while-checking", new String[0]));
                        break;
                    }
                    case ERROR_ALREADY_DOWNLOADED: {
                        sender.sendMessage(this.getMessages().getComponent("updater.already-downloaded", new String[0]));
                        break;
                    }
                    case ERROR_JAR_NOT_FOUND: {
                        sender.sendMessage(this.getMessages().getComponent("updater.errors.could-not-find-jar", new String[0]));
                        break;
                    }
                    case ERROR_WHILE_DOWNLOADING: {
                        sender.sendMessage(this.getMessages().getComponent("updater.errors.while-downloading", new String[0]));
                        break;
                    }
                    case ERROR_MISSING_UPDATE_TOKEN: {
                        sender.sendMessage(this.getMessages().getComponent("updater.errors.missing-update-token", new String[0]));
                        break;
                    }
                    case ERROR_INVALID_UPDATE_TOKEN: {
                        sender.sendMessage(this.getMessages().getComponent("updater.errors.invalid-update-token", new String[0]));
                        break;
                    }
                    default: {
                        sender.sendMessage(this.getMessages().getComponent("updater.errors.unknown", "ERROR:" + (Object)((Object)result)));
                        break;
                    }
                }
            }
            catch (Exception e) {
                sender.sendMessage(this.getMessages().getComponent("updater.errors.uncaught", new String[0]));
                this.main.getLogger().warn("Uncaught error while updating:", e);
            }
            this.main.getTaskManager().runLater(() -> {
                if (done.get()) {
                    return;
                }
                sender.sendMessage(this.getMessages().getComponent("updater.slow-feedback", new String[0]));
            }, 1L, TimeUnit.SECONDS);
        });
    }

    @Override
    public List<String> autoComplete(ICommandSender sender, String[] args) {
        return new ArrayList<String>();
    }
}

