/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.api.queues;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.UUID;
import us.ajg0702.queue.api.players.AdaptedPlayer;
import us.ajg0702.queue.api.players.QueuePlayer;
import us.ajg0702.queue.api.queueholders.QueueHolder;
import us.ajg0702.queue.api.queues.Balancer;
import us.ajg0702.queue.api.queues.QueueType;
import us.ajg0702.queue.api.server.AdaptedServer;

public interface QueueServer {
    public String getStatusString(AdaptedPlayer var1);

    public String getStatusString();

    public String getStatus(AdaptedPlayer var1);

    public String getStatus();

    public long getLastSentTime();

    public void setLastSentTime(long var1);

    public boolean isJoinable(AdaptedPlayer var1);

    public int getManualMaxPlayers();

    public boolean isManuallyFull();

    public void setPaused(boolean var1);

    public boolean isPaused();

    public void removePlayer(QueuePlayer var1);

    public void removePlayer(AdaptedPlayer var1);

    public void addPlayer(QueuePlayer var1);

    public void addPlayer(QueuePlayer var1, int var2);

    public void sendPlayer();

    public String getName();

    public boolean canAccess(AdaptedPlayer var1);

    public String getAlias();

    public ImmutableList<AdaptedServer> getServers();

    public ImmutableList<String> getServerNames();

    default public boolean isOnline() {
        for (AdaptedServer server : this.getServers()) {
            if (!server.isOnline()) continue;
            return true;
        }
        return false;
    }

    public boolean isGroup();

    public QueuePlayer findPlayer(String var1);

    public QueuePlayer findPlayer(AdaptedPlayer var1);

    public QueuePlayer findPlayer(UUID var1);

    public AdaptedServer getIdealServer(AdaptedPlayer var1);

    public List<Integer> getSupportedProtocols();

    public void setSupportedProtocols(List<Integer> var1);

    default public boolean isSupportedProtocol(int protocol) {
        if (this.getSupportedProtocols().isEmpty()) {
            return true;
        }
        return this.getSupportedProtocols().contains(protocol);
    }

    public Balancer getBalancer();

    public QueueHolder getQueueHolder();

    default public int getPosition(QueuePlayer player) {
        return this.getQueueHolder().getPosition(player);
    }

    public QueueType getLastQueueSend();

    public int getSendCount();

    public void incrementSendCount();

    public void resetSendCount();

    default public boolean elliot_is_bad() {
        return true;
    }
}

