/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.common.queues;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import us.ajg0702.queue.api.AjQueueAPI;
import us.ajg0702.queue.api.events.PositionChangeEvent;
import us.ajg0702.queue.api.players.AdaptedPlayer;
import us.ajg0702.queue.api.players.QueuePlayer;
import us.ajg0702.queue.api.queueholders.QueueHolder;
import us.ajg0702.queue.api.queues.Balancer;
import us.ajg0702.queue.api.queues.QueueServer;
import us.ajg0702.queue.api.queues.QueueType;
import us.ajg0702.queue.api.server.AdaptedServer;
import us.ajg0702.queue.api.server.AdaptedServerPing;
import us.ajg0702.queue.common.QueueMain;
import us.ajg0702.queue.common.players.QueuePlayerImpl;
import us.ajg0702.queue.common.queues.balancers.DefaultBalancer;
import us.ajg0702.queue.common.queues.balancers.FirstBalancer;
import us.ajg0702.queue.common.queues.balancers.MinigameBalancer;
import us.ajg0702.queue.common.utils.Debug;
import us.ajg0702.queue.libs.utils.common.Messages;

public class QueueServerImpl
implements QueueServer {
    private final String name;
    private final QueueMain main;
    private final List<AdaptedServer> servers;
    private final QueueHolder queueHolder = AjQueueAPI.getQueueHolderRegistry().getQueueHolder(this);
    private List<Integer> supportedProtocols = new ArrayList<Integer>();
    private Balancer balancer;
    private boolean paused;
    private long lastSentTime = 0L;
    private int manualMaxPlayers = Integer.MAX_VALUE;
    private QueueType lastQueueSend = QueueType.STANDARD;
    private int sendCount = 0;

    public QueueServerImpl(String name, QueueMain main, AdaptedServer server, List<QueuePlayer> previousStandardPlayers, List<QueuePlayer> previousExpressPlayers) {
        this(name, main, Collections.singletonList(server), previousStandardPlayers, previousExpressPlayers);
    }

    public QueueServerImpl(String name, QueueMain main, List<AdaptedServer> servers, List<QueuePlayer> previousStandardPlayers, List<QueuePlayer> previousExpressPlayers) {
        this.name = name;
        this.servers = servers;
        this.main = main;
        List<String> types = main.getConfig().getStringList("balancer-types");
        for (String string : types) {
            int colon = string.indexOf(":");
            if (colon == -1) continue;
            String groupName = string.substring(0, colon);
            String balancerType = string.substring(colon + 1);
            if (!groupName.equals(name)) continue;
            switch (balancerType.toLowerCase(Locale.ROOT)) {
                case "minigame": {
                    this.balancer = new MinigameBalancer(this, main);
                    break;
                }
                case "first": {
                    this.balancer = new FirstBalancer(this, main);
                    break;
                }
                default: {
                    balancerType = "default";
                    this.balancer = new DefaultBalancer(this, main);
                }
            }
            Debug.info("Using " + balancerType.toLowerCase(Locale.ROOT) + " balancer for " + name);
            break;
        }
        if (this.balancer == null) {
            this.balancer = new DefaultBalancer(this, main);
            Debug.info("Using default balancer for " + name);
        }
        List<String> manualLimits = main.getConfig().getStringList("manual-max-players");
        for (String manualLimit : manualLimits) {
            String[] parts = manualLimit.split(":");
            if (parts.length != 2) {
                main.getLogger().warn("Invalid manual limit: " + manualLimit);
                continue;
            }
            String limitFor = parts[0];
            if (!limitFor.equals(name)) continue;
            String limitStr = parts[1];
            try {
                this.manualMaxPlayers = Integer.parseInt(limitStr);
                break;
            }
            catch (NumberFormatException e) {
                main.getLogger().warn("Invalid limit number for " + limitFor);
                break;
            }
        }
        ArrayList<QueuePlayer> arrayList = new ArrayList<QueuePlayer>();
        arrayList.addAll(previousExpressPlayers);
        arrayList.addAll(previousStandardPlayers);
        for (QueuePlayer queuePlayer : arrayList) {
            if (queuePlayer.getPlayer() == null) {
                this.addPlayer(new QueuePlayerImpl(queuePlayer.getUniqueId(), queuePlayer.getName(), this, queuePlayer.getPriority(), queuePlayer.getMaxOfflineTime(), queuePlayer.getQueueType()));
                continue;
            }
            this.addPlayer(new QueuePlayerImpl(queuePlayer.getPlayer(), this, queuePlayer.getPriority(), queuePlayer.getMaxOfflineTime(), queuePlayer.getQueueType()));
        }
    }

    @Override
    public String getStatusString(AdaptedPlayer p) {
        Messages msgs = this.main.getMessages();
        AdaptedServer server = this.getIdealServer(p);
        if (server.getOfflineTime() > this.main.getConfig().getInt("offline-time")) {
            return msgs.getString("status.offline.offline", new String[0]);
        }
        if (!server.isOnline()) {
            return msgs.getString("status.offline.restarting", new String[0]);
        }
        if (this.isPaused()) {
            return msgs.getString("status.offline.paused", new String[0]);
        }
        if (server.isWhitelisted() && (p == null || !server.getWhitelistedPlayers().contains(p.getUniqueId()))) {
            return msgs.getString("status.offline.whitelisted", new String[0]);
        }
        if (server.isFull() && !server.canJoinFull(p) || this.isManuallyFull() && !AdaptedServer.canJoinFull(p, this.getName())) {
            return msgs.getString("status.offline.full", new String[0]);
        }
        if (p != null && !this.canAccess(p)) {
            return msgs.getString("status.offline.restricted", new String[0]);
        }
        return "online";
    }

    @Override
    public String getStatusString() {
        return this.getStatusString(null);
    }

    @Override
    public String getStatus(AdaptedPlayer p) {
        AdaptedServer server = this.getIdealServer(p);
        if (server.getOfflineTime() > this.main.getConfig().getInt("offline-time")) {
            return "offline";
        }
        if (!server.isOnline()) {
            return "restarting";
        }
        if (this.isPaused()) {
            return "paused";
        }
        if (server.isWhitelisted() && (p == null || !server.getWhitelistedPlayers().contains(p.getUniqueId()))) {
            return "whitelisted";
        }
        if (server.isFull() && !server.canJoinFull(p) || this.isManuallyFull() && !AdaptedServer.canJoinFull(p, this.getName())) {
            return "full";
        }
        if (p != null && !this.canAccess(p)) {
            return "restricted";
        }
        return "online";
    }

    @Override
    public String getStatus() {
        return this.getStatus(null);
    }

    @Override
    public long getLastSentTime() {
        return System.currentTimeMillis() - this.lastSentTime;
    }

    @Override
    public void setLastSentTime(long lastSentTime) {
        this.lastSentTime = lastSentTime;
    }

    @Override
    public boolean isJoinable(AdaptedPlayer p) {
        if (this.isManuallyFull() && !AdaptedServer.canJoinFull(p, this.getName())) {
            return false;
        }
        AdaptedServer server = this.getIdealServer(p);
        if (server == null) {
            return false;
        }
        return server.isJoinable(p) && !this.isPaused();
    }

    @Override
    public int getManualMaxPlayers() {
        return this.manualMaxPlayers;
    }

    @Override
    public boolean isManuallyFull() {
        int total = 0;
        for (AdaptedServer server : this.servers) {
            Optional<AdaptedServerPing> lastPing = server.getLastPing();
            if (!lastPing.isPresent()) continue;
            total += lastPing.get().getPlayerCount();
        }
        return total >= this.getManualMaxPlayers();
    }

    @Override
    public synchronized void setPaused(boolean paused) {
        this.paused = paused;
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public void removePlayer(QueuePlayer player) {
        this.main.getQueueManager().getSendingAttempts().remove(player);
        this.queueHolder.removePlayer(player);
        this.positionChange();
    }

    @Override
    public void removePlayer(AdaptedPlayer player) {
        QueuePlayer queuePlayer = this.findPlayer(player);
        if (queuePlayer == null) {
            return;
        }
        this.removePlayer(queuePlayer);
    }

    @Override
    public void addPlayer(QueuePlayer player) {
        this.addPlayer(player, -1);
    }

    @Override
    public void addPlayer(QueuePlayer player, int position) {
        if (!player.getQueueServer().equals(this) || this.queueHolder.findPlayer(player.getUniqueId()) != null) {
            return;
        }
        if (position >= 0) {
            this.queueHolder.addPlayer(player, position);
        } else {
            this.queueHolder.addPlayer(player);
        }
        this.positionChange();
    }

    @Override
    public void sendPlayer() {
        this.main.getQueueManager().sendPlayers(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean canAccess(AdaptedPlayer ply) {
        if (ply == null) {
            return true;
        }
        for (AdaptedServer si : this.servers) {
            if (!si.canAccess(ply)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getAlias() {
        return this.main.getAliasManager().getAlias(this.getName());
    }

    @Override
    public ImmutableList<AdaptedServer> getServers() {
        return ImmutableList.copyOf(this.servers);
    }

    @Override
    public ImmutableList<String> getServerNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (AdaptedServer server : this.servers) {
            names.add(server.getName());
        }
        return ImmutableList.copyOf(names);
    }

    @Override
    public boolean isOnline() {
        return QueueServer.super.isOnline();
    }

    @Override
    public boolean isGroup() {
        return this.servers.size() > 1;
    }

    @Override
    public QueuePlayer findPlayer(String player) {
        return this.queueHolder.findPlayer(player);
    }

    @Override
    public QueuePlayer findPlayer(AdaptedPlayer player) {
        return this.findPlayer(player.getUniqueId());
    }

    @Override
    public QueuePlayer findPlayer(UUID uuid) {
        return this.queueHolder.findPlayer(uuid);
    }

    @Override
    public AdaptedServer getIdealServer(AdaptedPlayer player) {
        return this.getBalancer().getIdealServer(player);
    }

    @Override
    public List<Integer> getSupportedProtocols() {
        return new ArrayList<Integer>(this.supportedProtocols);
    }

    @Override
    public void setSupportedProtocols(List<Integer> list) {
        this.supportedProtocols = new ArrayList<Integer>(list);
    }

    @Override
    public Balancer getBalancer() {
        return this.balancer;
    }

    @Override
    public QueueHolder getQueueHolder() {
        return this.queueHolder;
    }

    @Override
    public QueueType getLastQueueSend() {
        return this.lastQueueSend;
    }

    @Override
    public int getSendCount() {
        return this.sendCount;
    }

    @Override
    public void incrementSendCount() {
        ++this.sendCount;
    }

    @Override
    public void resetSendCount() {
        this.sendCount = 0;
    }

    public void setLastQueueSend(QueueType lastQueueSend) {
        this.lastQueueSend = lastQueueSend;
    }

    private void positionChange() {
        this.main.getTaskManager().runNow(() -> this.queueHolder.getAllPlayers().forEach(queuePlayer -> {
            if (((QueuePlayerImpl)queuePlayer).lastPosition != queuePlayer.getPosition()) {
                this.main.call(new PositionChangeEvent((QueuePlayer)queuePlayer));
            }
        }));
    }
}

