/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.libs.sponge.configurate.serialize;

import java.lang.reflect.Type;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.Nullable;
import us.ajg0702.queue.libs.sponge.configurate.ConfigurationNode;
import us.ajg0702.queue.libs.sponge.configurate.ConfigurationOptions;
import us.ajg0702.queue.libs.sponge.configurate.serialize.FunctionScalarSerializer;
import us.ajg0702.queue.libs.sponge.configurate.serialize.ScalarSerializer;
import us.ajg0702.queue.libs.sponge.configurate.serialize.SerializationException;
import us.ajg0702.queue.libs.sponge.configurate.util.CheckedFunction;

public interface TypeSerializer<T> {
    public static <T> ScalarSerializer<T> of(Type type, BiFunction<T, Predicate<Class<?>>, Object> serializer, CheckedFunction<Object, T, SerializationException> deserializer) {
        return new FunctionScalarSerializer<T>(type, deserializer, serializer);
    }

    public static <T> ScalarSerializer<T> of(Class<T> type, BiFunction<T, Predicate<Class<?>>, Object> serializer, CheckedFunction<Object, T, SerializationException> deserializer) {
        if (type.getTypeParameters().length > 0) {
            throw new IllegalArgumentException("Parameterized types must be specified using TypeTokens, not raw classes");
        }
        return new FunctionScalarSerializer<T>(type, deserializer, serializer);
    }

    public T deserialize(Type var1, ConfigurationNode var2) throws SerializationException;

    public void serialize(Type var1, @Nullable T var2, ConfigurationNode var3) throws SerializationException;

    default public @Nullable T emptyValue(Type specificType, ConfigurationOptions options) {
        return null;
    }
}

