/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.libs.utils.common;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import us.ajg0702.queue.libs.sponge.configurate.CommentedConfigurationNode;
import us.ajg0702.queue.libs.sponge.configurate.ConfigurateException;
import us.ajg0702.queue.libs.sponge.configurate.serialize.SerializationException;
import us.ajg0702.queue.libs.sponge.configurate.yaml.NodeStyle;
import us.ajg0702.queue.libs.sponge.configurate.yaml.YamlConfigurationLoader;
import us.ajg0702.queue.libs.utils.common.ConfigInterface;

public class ConfigFile
implements ConfigInterface {
    File f;
    CommentedConfigurationNode config;
    YamlConfigurationLoader loader;
    File pluginFolder;
    Logger logger;
    String nfm;
    private final Class<?> getDefaultFrom;
    String fileName;

    @Override
    public Object get(String key) {
        Object r = null;
        try {
            r = ((CommentedConfigurationNode)this.config.node(key.split("\\."))).get(Object.class);
        }
        catch (SerializationException serializationException) {
            // empty catch block
        }
        if (r == null) {
            this.logger.severe(this.nfm.replace("KEY", key));
        }
        return r;
    }

    @Override
    public Integer getInt(String key) {
        int r = ((CommentedConfigurationNode)this.config.node(key.split("\\."))).getInt(-38964298);
        if (r == -38964298) {
            this.logger.severe(this.nfm.replace("KEY", key));
        }
        return r;
    }

    @Override
    public String getString(String key) {
        String r = ((CommentedConfigurationNode)this.config.node(key.split("\\."))).getString();
        if (r == null) {
            this.logger.severe(this.nfm.replace("KEY", key));
        }
        return r;
    }

    @Override
    public List<String> getStringList(String key) {
        List<String> r = null;
        try {
            r = ((CommentedConfigurationNode)this.config.node(key.split("\\."))).getList(String.class);
        }
        catch (SerializationException serializationException) {
            // empty catch block
        }
        if (r == null) {
            this.logger.severe(this.nfm.replace("KEY", key));
        }
        return r;
    }

    @Override
    public boolean getBoolean(String key) {
        return ((CommentedConfigurationNode)this.config.node(key.split("\\."))).getBoolean();
    }

    @Override
    public double getDouble(String key) {
        double d = ((CommentedConfigurationNode)this.config.node(key.split("\\."))).getDouble(-3.8964298E7);
        if (d == -3.8964298E7) {
            this.logger.severe(this.nfm.replace("KEY", key));
        }
        return d;
    }

    public boolean hasEntry(String key) {
        return !((CommentedConfigurationNode)this.config.node(key.split("\\."))).virtual();
    }

    public String getDefaultConfig() throws IOException {
        String line;
        BufferedReader stream = new BufferedReader(new InputStreamReader(Objects.requireNonNull(this.getDefaultFrom.getResourceAsStream("/" + this.fileName))));
        StringBuilder configfile = new StringBuilder();
        while ((line = stream.readLine()) != null) {
            configfile.append(line).append("\n");
        }
        return configfile.toString();
    }

    public String getConfigString() throws IOException {
        List<String> lines = Files.readAllLines(Paths.get(this.pluginFolder.getPath(), this.fileName));
        StringBuilder end = new StringBuilder();
        for (String line : lines) {
            end.append(line).append("\n");
        }
        return end.toString();
    }

    public ConfigFile(File pluginFolder, Logger logger, String fileName) throws ConfigurateException {
        this(pluginFolder, logger, fileName, null);
    }

    public ConfigFile(File pluginFolder, Logger logger, String fileName, Class<?> getDefaultFrom) throws ConfigurateException {
        this.logger = logger;
        this.fileName = fileName;
        this.getDefaultFrom = getDefaultFrom == null ? this.getClass() : getDefaultFrom;
        this.pluginFolder = pluginFolder;
        this.nfm = "Could not find KEY in " + fileName + "! Try restarting the server, or deleting " + fileName + " and allowing the plugin to re-create it.";
        this.f = new File(pluginFolder, fileName);
        this.loader = ((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().file(this.f)).nodeStyle(NodeStyle.BLOCK).build();
        if (!this.f.exists()) {
            if (!Files.exists(pluginFolder.toPath(), new LinkOption[0])) {
                try {
                    Files.createDirectory(pluginFolder.toPath(), new FileAttribute[0]);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            try {
                String[] lines;
                PrintWriter writer = new PrintWriter(pluginFolder + File.separator + fileName, "UTF-8");
                for (String line : lines = this.getDefaultConfig().split("\n")) {
                    writer.println(line);
                }
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            try {
                this.f = new File(pluginFolder, fileName);
                YamlConfigurationLoader oldLoader = ((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().file(this.f)).nodeStyle(NodeStyle.BLOCK).build();
                CommentedConfigurationNode oldConfig = (CommentedConfigurationNode)oldLoader.load();
                String newConfig = this.getDefaultConfig();
                int oldver = ((CommentedConfigurationNode)oldConfig.node(new Object[]{"config-version"})).getInt(0);
                String strv = newConfig.split("config-version: ")[1].split("\n")[0];
                int newver = Integer.parseInt(strv);
                if (oldver < newver) {
                    String[] lines;
                    logger.info("Starting config converter!");
                    Date date = Calendar.getInstance().getTime();
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd-hh-mm-ss");
                    String strDate = dateFormat.format(date);
                    ConfigFile.duplicateFile(this.f, new File(pluginFolder, fileName + ".old." + strDate));
                    String oldConfigString = this.getConfigString();
                    this.f = new File(pluginFolder, fileName);
                    this.config = (CommentedConfigurationNode)this.loader.load();
                    logger.info(oldConfig.childrenMap().size() + " children");
                    for (Object keyObject : oldConfig.childrenMap().keySet()) {
                        String replace;
                        String nodeString;
                        String key = keyObject.toString() + ":";
                        logger.info("Key: " + key);
                        assert (key != null);
                        String[] keyParts = key.split("\\.");
                        String keySec = "\n" + keyParts[keyParts.length - 1];
                        logger.info("keySec: " + keySec);
                        String newVal = newConfig.split(keySec)[1].split("\n")[0];
                        logger.info("newVal before: " + newVal);
                        int i = 0;
                        for (String l : newConfig.split(keySec)[1].split("\n")) {
                            if (i == 0) {
                                ++i;
                                continue;
                            }
                            ++i;
                            logger.info("Scanning: " + l);
                            if (!l.trim().startsWith("-")) break;
                            newVal = newVal + "\n" + l;
                        }
                        logger.info("newVal after: " + newVal);
                        String find = keySec + newVal;
                        CommentedConfigurationNode node = (CommentedConfigurationNode)oldConfig.node(key.substring(0, key.length() - 1).split("\\."));
                        Object nodeObj = node.get(Object.class);
                        String string = nodeString = nodeObj == null ? null : nodeObj.toString();
                        if (node.isList()) {
                            List<String> list = node.getList(String.class);
                        }
                        logger.info("nodeString: " + nodeString);
                        if (!node.isList() && nodeString != null && (nodeString.contains(",") || nodeString.contains(".") || nodeString.isEmpty() || nodeString.contains("?")) && !nodeString.startsWith("\"") && !nodeString.startsWith("'")) {
                            nodeString = "\"" + nodeString + "\"";
                        }
                        if (!(replace = keySec + " " + (nodeString != null ? nodeString : "")).endsWith("[]")) {
                            replace = replace.replaceAll("\\[", "\n- \"");
                            replace = replace.replaceAll(", ", "\"\n- \"");
                            replace = replace.replaceAll("]", "\"");
                        }
                        if (keySec.contains("config-version") || replace.contains("null")) continue;
                        logger.info("Find: " + find + " Replace w: " + replace);
                        newConfig = newConfig.replaceAll("\\Q" + Matcher.quoteReplacement(find) + "\\E", Matcher.quoteReplacement(replace));
                    }
                    PrintWriter writer = new PrintWriter(this.f, "UTF-8");
                    for (String line : lines = newConfig.split("\n")) {
                        writer.println(line);
                    }
                    writer.close();
                }
            }
            catch (IOException e) {
                logger.severe("Unable to load default config! " + e.getMessage() + "\n" + Arrays.toString(e.getStackTrace()));
            }
        }
        this.f = new File(pluginFolder, fileName);
        this.config = (CommentedConfigurationNode)this.loader.load();
    }

    @Override
    public void reload() throws ConfigurateException {
        this.config = (CommentedConfigurationNode)this.loader.load();
    }

    public CommentedConfigurationNode getConfig() {
        return this.config;
    }

    public YamlConfigurationLoader getLoader() {
        return this.loader;
    }

    private static void duplicateFile(File source, File destination) throws IOException {
        try (FileInputStream is = new FileInputStream(source);
             FileOutputStream os = new FileOutputStream(destination);){
            int length;
            byte[] buffer = new byte[1024];
            while ((length = ((InputStream)is).read(buffer)) > 0) {
                ((OutputStream)os).write(buffer, 0, length);
            }
        }
    }
}

