/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.libs.utils.common;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import us.ajg0702.queue.libs.sponge.configurate.CommentedConfigurationNode;
import us.ajg0702.queue.libs.sponge.configurate.ConfigurateException;
import us.ajg0702.queue.libs.sponge.configurate.loader.HeaderMode;
import us.ajg0702.queue.libs.sponge.configurate.serialize.SerializationException;
import us.ajg0702.queue.libs.sponge.configurate.yaml.NodeStyle;
import us.ajg0702.queue.libs.sponge.configurate.yaml.YamlConfigurationLoader;
import us.ajg0702.queue.libs.utils.common.WritableConfigInterface;

public class SimpleConfig
implements WritableConfigInterface {
    private final YamlConfigurationLoader loader;
    private CommentedConfigurationNode parentNode;
    private final Logger logger;

    public SimpleConfig(File folder, String fileName, Logger logger) throws ConfigurateException {
        this(folder, fileName, logger, null);
    }

    public SimpleConfig(File folder, String fileName, Logger logger, String header) throws ConfigurateException {
        this.logger = logger;
        File file = new File(folder, fileName);
        YamlConfigurationLoader.Builder loaderBuilder = ((YamlConfigurationLoader.Builder)((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().headerMode(HeaderMode.PRESET)).file(file)).nodeStyle(NodeStyle.BLOCK);
        if (header != null) {
            loaderBuilder.defaultOptions(loaderBuilder.defaultOptions().header(header));
        }
        this.loader = loaderBuilder.build();
        if (!file.exists()) {
            if (!Files.exists(folder.toPath(), new LinkOption[0])) {
                try {
                    Files.createDirectory(folder.toPath(), new FileAttribute[0]);
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "Unable to folder for " + fileName + ":", e);
                }
            }
            try {
                InputStream defaultStream = this.getClass().getResourceAsStream("/" + fileName);
                if (defaultStream != null) {
                    Files.copy(defaultStream, file.toPath(), new CopyOption[0]);
                }
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Unable to create default file for " + fileName + ":", e);
            }
        }
        this.parentNode = (CommentedConfigurationNode)this.loader.load();
    }

    public CommentedConfigurationNode getNode(String path) {
        return (CommentedConfigurationNode)this.parentNode.node(this.path(path));
    }

    public CommentedConfigurationNode getNode() {
        return this.parentNode;
    }

    private Object[] path(String s) {
        return s.split("\\.");
    }

    @Override
    public Object get(String key) {
        try {
            return ((CommentedConfigurationNode)this.parentNode.node(this.path(key))).get(Object.class);
        }
        catch (SerializationException e) {
            return null;
        }
    }

    @Override
    public Integer getInt(String key) {
        return ((CommentedConfigurationNode)this.parentNode.node(this.path(key))).getInt(-1);
    }

    @Override
    public String getString(String key) {
        return ((CommentedConfigurationNode)this.parentNode.node(this.path(key))).getString();
    }

    @Override
    public List<String> getStringList(String key) {
        try {
            return ((CommentedConfigurationNode)this.parentNode.node(this.path(key))).getList(String.class);
        }
        catch (SerializationException e) {
            throw new IllegalArgumentException(key + " is not a list! " + e.getMessage());
        }
    }

    @Override
    public boolean getBoolean(String key) {
        return ((CommentedConfigurationNode)this.parentNode.node(this.path(key))).getBoolean();
    }

    @Override
    public double getDouble(String key) {
        return ((CommentedConfigurationNode)this.parentNode.node(this.path(key))).getDouble();
    }

    @Override
    public void reload() throws ConfigurateException {
        this.parentNode = (CommentedConfigurationNode)this.loader.load();
    }

    @Override
    public void set(String key, Object value) throws SerializationException {
        ((CommentedConfigurationNode)this.parentNode.node(this.path(key))).set(value);
    }

    @Override
    public void setInt(String key, int value) throws SerializationException {
        ((CommentedConfigurationNode)this.parentNode.node(this.path(key))).set(value);
    }

    @Override
    public void setString(String key, String value) throws SerializationException {
        ((CommentedConfigurationNode)this.parentNode.node(this.path(key))).set(value);
    }

    @Override
    public void setStringList(String key, List<String> value) throws SerializationException {
        ((CommentedConfigurationNode)this.parentNode.node(this.path(key))).set(value);
    }

    @Override
    public void setBoolean(String key, boolean value) throws SerializationException {
        ((CommentedConfigurationNode)this.parentNode.node(this.path(key))).set(value);
    }

    @Override
    public void setDouble(String key, double value) throws SerializationException {
        ((CommentedConfigurationNode)this.parentNode.node(this.path(key))).set(value);
    }

    @Override
    public void save() throws IOException {
        this.loader.save(this.parentNode);
    }
}

