/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.spigot;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.io.File;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.server.ServerListPingEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.jetbrains.annotations.NotNull;
import us.ajg0702.queue.api.AjQueueAPI;
import us.ajg0702.queue.api.communication.ComResponse;
import us.ajg0702.queue.api.spigot.AjQueueSpigotAPI;
import us.ajg0702.queue.libs.utils.common.ConfigFile;
import us.ajg0702.queue.libs.utils.common.Messages;
import us.ajg0702.queue.libs.utils.foliacompat.CompatScheduler;
import us.ajg0702.queue.spigot.QueueScoreboardActivator;
import us.ajg0702.queue.spigot.api.SpigotAPI;
import us.ajg0702.queue.spigot.commands.SpigotLeaveQueueCommand;
import us.ajg0702.queue.spigot.commands.SpigotQueueCommand;
import us.ajg0702.queue.spigot.communication.ResponseManager;
import us.ajg0702.queue.spigot.placeholders.Placeholder;
import us.ajg0702.queue.spigot.placeholders.PlaceholderExpansion;
import us.ajg0702.queue.spigot.placeholders.RefetchablePlaceholder;

public class SpigotMain
extends JavaPlugin
implements PluginMessageListener,
Listener {
    private boolean papi = false;
    private PlaceholderExpansion placeholders;
    private ResponseManager responseManager = new ResponseManager();
    private final CompatScheduler compatScheduler = new CompatScheduler((Plugin)this);
    private ConfigFile config;
    private boolean hasProxy = false;
    final HashMap<Player, String> queuebatch = new HashMap();

    public void onLoad() {
        File oldConfig = new File(this.getDataFolder(), "config.yml");
        if (oldConfig.exists()) {
            oldConfig.renameTo(new File(this.getDataFolder(), "spigot-config.yml"));
        }
        try {
            this.config = new ConfigFile(this.getDataFolder(), this.getLogger(), "spigot-config.yml");
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Unable to read config:", e);
        }
        if (this.config.getBoolean("enable-commands")) {
            try {
                Field bukkitCommandMap = Bukkit.getServer().getClass().getDeclaredField("commandMap");
                bukkitCommandMap.setAccessible(true);
                CommandMap commandMap = (CommandMap)bukkitCommandMap.get(Bukkit.getServer());
                commandMap.register("queue", (Command)new SpigotQueueCommand(this, this.config.getBoolean("enable-server-alias"), this.config.getBoolean("enable-spigotqueue-alias")));
                commandMap.register("leavequeue", (Command)new SpigotLeaveQueueCommand(this));
                this.getLogger().info("Registered backend commands");
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                this.getLogger().log(Level.SEVERE, "Unable to register backend commands:", e);
            }
        } else {
            this.getLogger().info("Not registering backend commands because they are disabled in spigot-config.yml");
        }
    }

    public void onEnable() {
        this.getServer().getMessenger().registerIncomingPluginChannel((Plugin)this, "ajqueue:tospigot", (PluginMessageListener)this);
        this.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, "ajqueue:toproxy");
        AjQueueSpigotAPI.INSTANCE = AjQueueAPI.SPIGOT_INSTANCE = new SpigotAPI(this.responseManager, this);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        boolean bl = this.papi = Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null;
        if (this.papi) {
            this.placeholders = new PlaceholderExpansion(this);
            this.placeholders.register();
            this.getLogger().info("Registered PlaceholderAPI placeholders");
        }
        this.getScheduler().runTaskTimerAsynchronously(() -> {
            if (Bukkit.getOnlinePlayers().size() <= 0 || this.queuebatch.size() <= 0) {
                return;
            }
            StringBuilder msg = new StringBuilder();
            for (Player p : this.queuebatch.keySet()) {
                if (p == null || !p.isOnline()) continue;
                msg.append(p.getName()).append(":").append(this.queuebatch.get(p)).append(",");
            }
            if (msg.length() > 1) {
                msg = new StringBuilder(msg.substring(0, msg.length() - 1));
            }
            this.queuebatch.clear();
            this.sendMessage("massqueue", msg.toString());
        }, 40L, 20L);
        this.getLogger().info("Spigot side enabled! v" + this.getDescription().getVersion());
    }

    public boolean hasProxy() {
        return this.hasProxy;
    }

    public void onPluginMessageReceived(@NotNull String channel, @NotNull Player player, byte[] message) {
        if (!channel.equals("ajqueue:tospigot")) {
            return;
        }
        ByteArrayDataInput in = ByteStreams.newDataInput((byte[])message);
        String subchannel = in.readUTF();
        if (subchannel.equals("ack")) {
            this.hasProxy = true;
            return;
        }
        if (subchannel.equals("inqueueevent")) {
            QueueScoreboardActivator e = new QueueScoreboardActivator(player);
            Bukkit.getPluginManager().callEvent((Event)e);
            return;
        }
        if (subchannel.equals("player-joined-queue") && this.papi) {
            for (Placeholder placeholderImplementation : this.placeholders.getPlaceholderImplementations()) {
                if (!(placeholderImplementation instanceof RefetchablePlaceholder)) continue;
                RefetchablePlaceholder placeholder = (RefetchablePlaceholder)((Object)placeholderImplementation);
                placeholder.refetch((OfflinePlayer)player);
            }
            return;
        }
        try {
            ComResponse response = ComResponse.from(subchannel, in);
            this.responseManager.executeResponse(response);
        }
        catch (IllegalStateException response) {
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Error while processing proxy response " + subchannel + ": ", e);
        }
    }

    public void sendMessage(Player player, String subchannel, String data) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF(subchannel);
        out.writeUTF(data);
        player.sendPluginMessage((Plugin)this, "ajqueue:toproxy", out.toByteArray());
    }

    public void sendMessage(String subchannel, String data) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF(subchannel);
        out.writeUTF(data);
        ((Player)Bukkit.getOnlinePlayers().iterator().next()).sendPluginMessage((Plugin)this, "ajqueue:toproxy", out.toByteArray());
    }

    @EventHandler
    public void onLeave(PlayerQuitEvent e) {
        if (this.papi) {
            this.placeholders.cleanCache(e.getPlayer());
        }
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent e) {
        if (this.hasProxy || !this.config.getBoolean("check-proxy-response")) {
            return;
        }
        this.getScheduler().runTaskLaterAsynchronously(() -> this.sendMessage(e.getPlayer(), "ack", ""), 5L);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onServerPing(ServerListPingEvent e) {
        if (this.config == null) {
            this.getLogger().warning("Server ping before plugin load!");
            return;
        }
        if (!this.config.getBoolean("take-over-motd-for-whitelist")) {
            return;
        }
        if (!Bukkit.hasWhitelist()) {
            return;
        }
        StringBuilder whitelist = new StringBuilder();
        for (OfflinePlayer player : Bukkit.getWhitelistedPlayers()) {
            whitelist.append(player.getUniqueId()).append(",");
        }
        if (whitelist.length() > 1) {
            whitelist.deleteCharAt(whitelist.length() - 1);
        }
        e.setMotd("ajQueue;whitelisted=" + whitelist);
    }

    public boolean checkProxyResponse(CommandSender sender) {
        if (!this.hasProxy() && this.config.getBoolean("check-proxy-response")) {
            if (sender instanceof Player) {
                this.sendMessage((Player)sender, "ack", "");
            }
            sender.sendMessage(Messages.color("&c" + (sender.hasPermission("ajqueue.manage") ? "ajQueue" : "The queue plugin") + " must also be installed on the proxy!&7 If it has been installed on the proxy, make sure it loaded correctly and try again."));
            return true;
        }
        return false;
    }

    public CompatScheduler getScheduler() {
        return this.compatScheduler;
    }

    public ConfigFile getAConfig() {
        return this.config;
    }

    public HashMap<Player, String> getQueueBatch() {
        return this.queuebatch;
    }
}

