/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.common;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import us.ajg0702.queue.api.ServerTimeManager;
import us.ajg0702.queue.api.players.AdaptedPlayer;

public class ServerTimeManagerImpl
implements ServerTimeManager {
    final Map<UUID, Long> serverSwitches = new ConcurrentHashMap<UUID, Long>();

    @Override
    public long getLastServerChange(AdaptedPlayer player) {
        if (player == null) {
            return -1L;
        }
        Long r = this.serverSwitches.get(player.getUniqueId());
        return r == null ? -1L : r;
    }

    public void playerChanged(AdaptedPlayer player) {
        if (player == null) {
            return;
        }
        this.serverSwitches.put(player.getUniqueId(), System.currentTimeMillis());
    }

    public void removePlayer(AdaptedPlayer player) {
        if (player == null) {
            return;
        }
        this.serverSwitches.remove(player.getUniqueId());
    }
}

