/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.common.communication.handlers;

import us.ajg0702.queue.api.communication.ComResponse;
import us.ajg0702.queue.api.players.AdaptedPlayer;
import us.ajg0702.queue.api.players.QueuePlayer;
import us.ajg0702.queue.api.queues.QueueServer;
import us.ajg0702.queue.common.QueueMain;
import us.ajg0702.queue.common.communication.MessageHandler;
import us.ajg0702.queue.libs.utils.common.TimeUtils;

public class EstimatedTimeHandler
extends MessageHandler {
    public EstimatedTimeHandler(QueueMain main) {
        super(main);
    }

    @Override
    public ComResponse handleMessage(AdaptedPlayer player, String data) {
        String timeString;
        QueueServer server = this.main.getQueueManager().getSingleServer(player);
        if (server != null) {
            QueuePlayer queuePlayer = server.findPlayer(player);
            int time = (int)Math.round((double)queuePlayer.getPosition() * this.main.getTimeBetweenPlayers());
            timeString = TimeUtils.timeString(time, this.main.getMessages().getString("format.time.mins", new String[0]), this.main.getMessages().getString("format.time.secs", new String[0]));
        } else {
            timeString = this.main.getMessages().getString("placeholders.estimated_time.none", new String[0]);
        }
        return ComResponse.from("estimated_time").id(player.getUniqueId()).with(timeString);
    }
}

