/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.common.players;

import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import us.ajg0702.queue.api.events.PreConnectEvent;
import us.ajg0702.queue.api.players.AdaptedPlayer;
import us.ajg0702.queue.api.players.QueuePlayer;
import us.ajg0702.queue.api.queues.QueueServer;
import us.ajg0702.queue.api.server.AdaptedServer;
import us.ajg0702.queue.common.QueueMain;

public class QueuePlayerImpl
implements QueuePlayer {
    private AdaptedPlayer player;
    private final QueueServer server;
    private final int highestPriority;
    private final UUID uuid;
    private final String name;
    private final int maxOfflineTime;
    private final AdaptedServer initialServer;
    public int lastPosition;
    private long leaveTime = 0L;

    public QueuePlayerImpl(UUID uuid, String name, QueueServer server, int highestPriority, int maxOfflineTime) {
        this(null, name, uuid, server, highestPriority, maxOfflineTime);
    }

    public QueuePlayerImpl(AdaptedPlayer player, QueueServer server, int highestPriority, int maxOfflineTime) {
        this(player, player.getName(), player.getUniqueId(), server, highestPriority, maxOfflineTime);
    }

    private QueuePlayerImpl(@Nullable AdaptedPlayer player, String name, @NotNull UUID uuid, QueueServer server, int highestPriority, int maxOfflineTime) {
        this.player = player;
        this.server = server;
        this.highestPriority = highestPriority;
        this.uuid = uuid;
        this.name = name;
        this.maxOfflineTime = maxOfflineTime;
        this.initialServer = player != null ? player.getCurrentServer() : null;
        this.lastPosition = this.getPosition();
    }

    @Override
    public UUID getUniqueId() {
        if (this.uuid == null) {
            throw new IllegalStateException("Why is my UUID null??");
        }
        return this.uuid;
    }

    @Override
    public QueueServer getQueueServer() {
        return this.server;
    }

    @Override
    @Nullable
    public AdaptedPlayer getPlayer() {
        if (this.player != null && !this.player.isConnected()) {
            this.player = null;
        }
        return this.player;
    }

    @Override
    public void setPlayer(AdaptedPlayer player) {
        if (player != null && !player.getUniqueId().equals(this.getUniqueId())) {
            throw new IllegalArgumentException("UUIDs do not match");
        }
        this.player = player;
    }

    @Override
    public int getPriority() {
        return this.highestPriority;
    }

    @Override
    public boolean hasPriority() {
        return this.highestPriority > 0;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getTimeSinceOnline() {
        if (this.player != null && this.player.isConnected()) {
            return 0L;
        }
        return System.currentTimeMillis() - this.leaveTime;
    }

    @Override
    public int getMaxOfflineTime() {
        return this.maxOfflineTime;
    }

    @Override
    public AdaptedServer getInitialServer() {
        return this.initialServer;
    }

    public void setLeaveTime(long leaveTime) {
        this.leaveTime = leaveTime;
    }

    @Override
    public void connect(@NotNull AdaptedServer server) {
        AdaptedPlayer player = this.getPlayer();
        if (player == null) {
            throw new IllegalArgumentException("Player must be online!");
        }
        PreConnectEvent preConnectEvent = new PreConnectEvent(server, this);
        QueueMain.getInstance().call(preConnectEvent);
        if (preConnectEvent.isCancelled()) {
            return;
        }
        player.connect(preConnectEvent.getTargetServer());
    }
}

