/*
 * Copyright (C) 2025  DragonsPlus
 * SPDX-License-Identifier: LGPL-3.0-or-later
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package plus.dragons.createdragonsplus.common.registry;

import com.simibubi.create.api.registry.SimpleRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import plus.dragons.createdragonsplus.common.processing.freeze.BlockFreezer;

public class CDPBlockFreezers {
    public static void register() {
        BlockFreezer.REGISTRY.registerProvider(SimpleRegistry.Provider
                .forBlockTag(CDPBlocks.MOD_TAGS.passiveBlockFreezers, CDPBlockFreezers::passive));
    }

    public static float passive(Level level, BlockPos pos, BlockState state) {
        return 0;
    }
}
