/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createdragonsplus.common.recipe;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.AddReloadListenerEvent;

@EventBusSubscriber
public interface RecipeConverter<K extends Recipe<?>, V extends Recipe<?>>
extends Function<RecipeHolder<K>, RecipeHolder<V>> {
    public static final Map<RecipeConverter<?, ?>, Runnable> CACHE_INVALIDATORS = new IdentityHashMap();

    @SubscribeEvent
    public static void onAddReloadListener(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)((ResourceManagerReloadListener)resourceManager -> CACHE_INVALIDATORS.values().forEach(Runnable::run)));
    }

    public static <K extends Recipe<?>, V extends Recipe<?>> RecipeConverter<K, V> cached(CacheBuilder<Object, Object> cacheBuilder, final RecipeConverter<K, V> converter) {
        LoadingCache cache = cacheBuilder.build(new CacheLoader<RecipeHolder<K>, RecipeHolder<V>>(){

            public RecipeHolder<V> load(RecipeHolder<K> key) {
                return (RecipeHolder)converter.apply(key);
            }
        });
        RecipeConverter result = arg_0 -> ((LoadingCache)cache).getUnchecked(arg_0);
        CACHE_INVALIDATORS.put(result, () -> ((LoadingCache)cache).invalidateAll());
        return result;
    }
}

