/*
 * Decompiled with CFR 0.152.
 */
package fermiumbooter;

import com.llamalad7.mixinextras.MixinExtrasBootstrap;
import fermiumbooter.FermiumRegistryAPI;
import fermiumbooter.util.CustomLogger;
import fermiumbooter.util.FermiumJarScanner;
import fermiumbooter.util.ForcedConfigHandler;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraftforge.fml.relauncher.IFMLLoadingPlugin;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.launch.MixinBootstrap;
import org.spongepowered.asm.mixin.Mixins;

@IFMLLoadingPlugin.Name(value="FermiumBooter")
@IFMLLoadingPlugin.MCVersion(value="1.12.2")
@IFMLLoadingPlugin.SortingIndex(value=990)
public class FermiumPlugin
implements IFMLLoadingPlugin {
    public static final Logger LOGGER = LogManager.getLogger((String)"FermiumBooter");

    public FermiumPlugin() {
        MixinBootstrap.init();
        MixinExtrasBootstrap.init();
        Mixins.addConfiguration((String)"mixins.fermiumbooter.init.json");
    }

    public String[] getASMTransformerClass() {
        return new String[0];
    }

    public String getModContainerClass() {
        return null;
    }

    public String getSetupClass() {
        return null;
    }

    public void injectData(Map<String, Object> data) {
        CustomLogger.init();
        FermiumJarScanner.handleCaching();
        FermiumJarScanner.clearCaches();
        for (Map.Entry<String, List<Supplier<Boolean>>> entry : FermiumRegistryAPI.getEarlyMixins().entrySet()) {
            if (FermiumRegistryAPI.getRejectMixins().contains(entry.getKey())) {
                LOGGER.log(Level.INFO, "FermiumBooter received removal of \"{}\" for early mixin application, rejecting.", (Object)entry.getKey());
                continue;
            }
            boolean enabled = false;
            for (Supplier<Boolean> supplier : entry.getValue()) {
                Boolean supplied = supplier.get();
                if (supplied == null) {
                    LOGGER.log(Level.WARN, "FermiumBooter received null value from early application supplier for \"{}\".", (Object)entry.getKey());
                    continue;
                }
                enabled |= supplied.booleanValue();
            }
            if (!enabled) continue;
            LOGGER.log(Level.INFO, "FermiumBooter adding \"{}\" for early mixin application.", (Object)entry.getKey());
            Mixins.addConfiguration((String)entry.getKey());
        }
    }

    public String getAccessTransformerClass() {
        return null;
    }

    static {
        ForcedConfigHandler.handleForcedMixinConfigs();
    }
}

