/*
 * Decompiled with CFR 0.152.
 */
package fermiumbooter.config;

import fermiumbooter.annotations.MixinConfig;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="fermiumbooter")
@MixinConfig(name="fermiumbooter")
public class FermiumBooterConfig {
    @Config.Comment(value={"Prevents the mixin compatibility warning text from rendering on screen\nErrors and warnings will still be printed to the log"})
    @Config.Name(value="Suppress Mixin Compatibility Warnings Render")
    public static boolean suppressMixinCompatibilityWarningsRender = false;
    @Config.Comment(value={"Disables config based mixin compatibility checks\nWarning: this may cause undefined behavior in mods, you should not enable this if not absolutely required\nDo not report issues to any mods if you have this enabled unless you want to be laughed at"})
    @Config.Name(value="Override Mixin Config Compatibility Checks")
    @Config.RequiresMcRestart
    public static boolean overrideMixinCompatibilityChecks = false;
    @Config.Comment(value={"Mixin config json files to forcibly remove from FermiumBooter enqueue"})
    @Config.Name(value="Forced Early Mixin Config Removals")
    @Config.RequiresMcRestart
    public static String[] forcedEarlyMixinConfigRemovals = new String[0];
    @Config.Comment(value={"Appends prior mixin exceptions to crash reports to help diagnose crashes"})
    @Config.Name(value="Append General Mixin Exceptions To Crash Reports")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(earlyMixin="mixins.fermiumbooter.crashreport.json", defaultValue=true)
    public static boolean appendGeneralMixinExceptionsToCrashReports = true;

    @Mod.EventBusSubscriber(modid="fermiumbooter")
    private static class ConfigSyncHandler {
        private ConfigSyncHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("fermiumbooter")) {
                ConfigManager.sync((String)"fermiumbooter", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }
}

