/*
 * Decompiled with CFR 0.152.
 */
package fermiumbooter.util;

import fermiumbooter.FermiumPlugin;
import fermiumbooter.FermiumRegistryAPI;
import java.io.File;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.stream.Stream;
import org.apache.logging.log4j.Level;

public abstract class ForcedConfigHandler {
    private static int removedMixinConfigCount = 0;

    public static void handleForcedMixinConfigs() {
        FermiumPlugin.LOGGER.log(Level.INFO, "FermiumBooter beginning forced mixin config handling.");
        ForcedConfigHandler.parseForcedMixinConfig();
        FermiumPlugin.LOGGER.log(Level.INFO, "FermiumBooter finished forced mixin config handling, removed {} mixin configs.", (Object)removedMixinConfigCount);
    }

    private static void parseForcedMixinConfig() {
        File configFile = new File("config", "fermiumbooter.cfg");
        ArrayList forcedRemoves = new ArrayList();
        if (configFile.exists() && configFile.isFile()) {
            try (Stream<String> stream = Files.lines(configFile.toPath());){
                boolean[] parsingRemove = new boolean[]{false};
                stream.forEachOrdered(s -> {
                    String st = s.trim();
                    if (!st.isEmpty()) {
                        if (parsingRemove[0]) {
                            if (st.contains(".json")) {
                                forcedRemoves.add(st);
                            } else {
                                parsingRemove[0] = false;
                            }
                        } else if (st.contains("S:\"Forced Early Mixin Config Removals\"")) {
                            parsingRemove[0] = true;
                        }
                    }
                });
            }
            catch (Exception ex) {
                FermiumPlugin.LOGGER.log(Level.ERROR, "FermiumBooter failed to read FermiumBooter config:", (Throwable)ex);
            }
        } else {
            FermiumPlugin.LOGGER.log(Level.INFO, "FermiumBooter config missing, assuming first launch.");
        }
        for (String remove : forcedRemoves) {
            ++removedMixinConfigCount;
            FermiumRegistryAPI.removeMixin(remove);
        }
    }
}

