/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.mixinsquared.adjuster;

import com.bawnorton.mixinsquared.adjuster.tools.AdjustableAnnotationNode;
import com.bawnorton.mixinsquared.api.MixinAnnotationAdjuster;
import com.bawnorton.mixinsquared.util.AnnotationEqualityVisitor;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.ApiStatus;
import org.objectweb.asm.tree.MethodNode;
import org.spongepowered.asm.logging.ILogger;
import org.spongepowered.asm.service.MixinService;

public final class MixinAnnotationAdjusterRegistrar {
    private static final Set<MixinAnnotationAdjuster> adjusters = new HashSet<MixinAnnotationAdjuster>();
    private static final ILogger LOGGER = MixinService.getService().getLogger("mixinsquared");

    @ApiStatus.Internal
    public static AdjustableAnnotationNode adjust(List<String> targetClassNames, String mixinClassName, MethodNode handlerNode, AdjustableAnnotationNode annotationNode, BiConsumer<String, AdjustableAnnotationNode> postAdjustmentConsumer) {
        for (MixinAnnotationAdjuster adjuster : adjusters) {
            AnnotationEqualityVisitor equalityVisitor = new AnnotationEqualityVisitor(annotationNode.copy());
            annotationNode = adjuster.adjust(targetClassNames, mixinClassName, handlerNode, annotationNode);
            equalityVisitor.visit(annotationNode);
            if (equalityVisitor.isEqual()) continue;
            postAdjustmentConsumer.accept(adjuster.getClass().getName(), annotationNode);
        }
        return annotationNode;
    }

    public static void register(MixinAnnotationAdjuster adjuster) {
        adjusters.add(adjuster);
        LOGGER.debug("Registered annotation adjuster {}", adjuster.getClass().getName());
    }
}

