/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.mixinsquared.adjuster.tools.type;

import com.bawnorton.mixinsquared.adjuster.tools.AdjustableAnnotationNode;
import com.bawnorton.mixinsquared.adjuster.tools.AdjustableSliceNode;
import com.bawnorton.mixinsquared.adjuster.tools.type.RemappableAnnotationNode;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.ApiStatus;

public interface SliceListAnnotationNode
extends RemappableAnnotationNode {
    default public List<AdjustableSliceNode> getSlice() {
        return this.get("slice").map(nodes -> {
            List<AdjustableSliceNode> sliceNodes = AdjustableAnnotationNode.fromList(nodes, AdjustableSliceNode::new);
            sliceNodes.forEach(slice -> slice.withFrom(from -> {
                from.setRemapper((Consumer)this.getRemapper());
                return from;
            }).withTo(to -> {
                to.setRemapper((Consumer)this.getRemapper());
                return to;
            }));
            return sliceNodes;
        }).orElse(new ArrayList());
    }

    default public void setSlice(List<AdjustableSliceNode> slice) {
        this.set("slice", slice);
    }

    default public SliceListAnnotationNode withSlice(UnaryOperator<List<AdjustableSliceNode>> slice) {
        this.setSlice((List)slice.apply(this.getSlice()));
        return this;
    }

    @Override
    @ApiStatus.Internal
    default public void applyRefmap(UnaryOperator<String> refmapApplicator) {
        this.withSlice(slices -> {
            for (AdjustableSliceNode slice : slices) {
                slice.withFrom(from -> {
                    from.applyRefmap(refmapApplicator);
                    return from;
                }).withTo(to -> {
                    to.applyRefmap(refmapApplicator);
                    return to;
                });
            }
            return slices;
        });
    }
}

