/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.mixinsquared.reflection;

import com.bawnorton.mixinsquared.reflection.FieldReference;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.spongepowered.asm.mixin.refmap.IMixinContext;
import org.spongepowered.tools.obfuscation.interfaces.IObfuscationManager;
import org.spongepowered.tools.obfuscation.interfaces.ITypeHandleProvider;

@ApiStatus.Internal
public final class AnnotatedMixinExtension {
    private final Object reference;
    private final FieldReference<IObfuscationManager> obfField;
    private final FieldReference<ITypeHandleProvider> typeProviderField;

    public AnnotatedMixinExtension(IMixinContext reference) {
        this.reference = reference;
        this.obfField = new FieldReference(reference.getClass(), "obf");
        this.typeProviderField = new FieldReference(reference.getClass(), "typeProvider");
    }

    public static void tryAs(IMixinContext reference, Consumer<AnnotatedMixinExtension> consumer) {
        if (reference.getClass().getName().equals("org.spongepowered.tools.obfuscation.AnnotatedMixin")) {
            consumer.accept(new AnnotatedMixinExtension(reference));
        }
    }

    public IObfuscationManager getObfuscationManager() {
        return this.obfField.get(this.reference);
    }

    public ITypeHandleProvider getTypeProvider() {
        return this.typeProviderField.get(this.reference);
    }
}

