/*
 * Decompiled with CFR 0.152.
 */
package fermiumbooter.mixin;

import fermiumbooter.FermiumPlugin;
import fermiumbooter.FermiumRegistryAPI;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModClassLoader;
import net.minecraftforge.fml.common.ModContainer;
import org.apache.logging.log4j.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.Mixins;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.transformer.ext.Extensions;

@Mixin(value={Loader.class})
public abstract class FermiumMixinLoader {
    @Shadow(remap=false)
    private List<ModContainer> mods;
    @Shadow(remap=false)
    private ModClassLoader modClassLoader;

    @Inject(method={"loadMods"}, at={@At(value="INVOKE", target="Lnet/minecraftforge/fml/common/LoadController;transition(Lnet/minecraftforge/fml/common/LoaderState;Z)V", ordinal=1)}, remap=false)
    private void beforeConstructingMods(List<String> nonMod, CallbackInfo ci) {
        for (ModContainer modContainer : this.mods) {
            try {
                this.modClassLoader.addFile(modContainer.getSource());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        for (Map.Entry entry : FermiumRegistryAPI.getLateMixins().entrySet()) {
            if (FermiumRegistryAPI.getRejectMixins().contains(entry.getKey())) {
                FermiumPlugin.LOGGER.log(Level.INFO, "FermiumBooter received removal of \"{}\" for late mixin application, rejecting.", entry.getKey());
                continue;
            }
            boolean enabled = false;
            for (Supplier supplier : (List)entry.getValue()) {
                Boolean supplied = (Boolean)supplier.get();
                if (supplied == null) {
                    FermiumPlugin.LOGGER.log(Level.WARN, "FermiumBooter received null value from late application supplier for \"{}\".", entry.getKey());
                    continue;
                }
                enabled |= supplied.booleanValue();
            }
            if (!enabled) continue;
            FermiumPlugin.LOGGER.log(Level.INFO, "FermiumBooter adding \"{}\" for late mixin application.", entry.getKey());
            Mixins.addConfiguration((String)entry.getKey());
        }
        FermiumRegistryAPI.clear();
        try {
            Class<?> proxyClass = Class.forName("org.spongepowered.asm.mixin.transformer.Proxy");
            Field field = proxyClass.getDeclaredField("transformer");
            field.setAccessible(true);
            Object transformer = field.get(null);
            Class<?> mixinTransformerClass = Class.forName("org.spongepowered.asm.mixin.transformer.MixinTransformer");
            Field processorField = mixinTransformerClass.getDeclaredField("processor");
            processorField.setAccessible(true);
            Object processor = processorField.get(transformer);
            Class<?> mixinProcessorClass = Class.forName("org.spongepowered.asm.mixin.transformer.MixinProcessor");
            Field extensionsField = mixinProcessorClass.getDeclaredField("extensions");
            extensionsField.setAccessible(true);
            Object extensions = extensionsField.get(processor);
            Method selectConfigsMethod = mixinProcessorClass.getDeclaredMethod("selectConfigs", MixinEnvironment.class);
            selectConfigsMethod.setAccessible(true);
            selectConfigsMethod.invoke(processor, MixinEnvironment.getCurrentEnvironment());
            try {
                Method prepareConfigs = mixinProcessorClass.getDeclaredMethod("prepareConfigs", MixinEnvironment.class, Extensions.class);
                prepareConfigs.setAccessible(true);
                prepareConfigs.invoke(processor, MixinEnvironment.getCurrentEnvironment(), extensions);
                return;
            }
            catch (NoSuchMethodException prepareConfigs) {
                try {
                    Method prepareConfigs2 = mixinProcessorClass.getDeclaredMethod("prepareConfigs", MixinEnvironment.class);
                    prepareConfigs2.setAccessible(true);
                    prepareConfigs2.invoke(processor, MixinEnvironment.getCurrentEnvironment());
                    return;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new UnsupportedOperationException("Unsupported Mixin");
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

