/*
 * Decompiled with CFR 0.152.
 */
package fermiumbooter.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import fermiumbooter.FermiumRegistryAPI;
import fermiumbooter.util.ASMClassVisitor;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import net.minecraftforge.fml.relauncher.libraries.Artifact;
import net.minecraftforge.fml.relauncher.libraries.LibraryManager;
import net.minecraftforge.fml.relauncher.libraries.Repository;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public abstract class FermiumJarScanner {
    private static final Pattern classFilePattern = Pattern.compile("[^\\s\\$]+(\\$[^\\s]+)?\\.class$");
    private static final Logger LOGGER = LogManager.getLogger((String)"FermiumJarScanner");
    private static final List<ASMClassVisitor> parsedClassVisitors = new ArrayList<ASMClassVisitor>();
    private static final Set<String> earlyModIDs = new HashSet<String>();
    private static int mixinConfigCount = 0;
    private static int warningCount = 0;
    private static Boolean skipCompatHandlingChecks = null;
    private static final Map<String, String> modConfigMap = new HashMap<String, String>();

    public static boolean isModPresent(String modID) {
        if (modID == null || modID.isEmpty()) {
            return false;
        }
        FermiumJarScanner.handleCaching();
        return earlyModIDs.contains(modID);
    }

    public static void handleCaching() {
        if (!earlyModIDs.isEmpty() || !parsedClassVisitors.isEmpty()) {
            return;
        }
        LOGGER.log(Level.INFO, "FermiumJarScanner beginning jar searching.");
        FermiumJarScanner.startJarSearching();
        LOGGER.log(Level.INFO, "FermiumJarScanner finished jar searching, found {} ModIDs.", (Object)earlyModIDs.size());
        LOGGER.log(Level.INFO, "FermiumMixinConfig beginning MixinConfig parsing.");
        for (ASMClassVisitor classVisitor : parsedClassVisitors) {
            FermiumJarScanner.parseMixinConfigVisitor(classVisitor);
        }
        LOGGER.log(Level.INFO, "FermiumMixinConfig finished MixinConfig parsing, parsed {} config options with {} warnings", (Object)mixinConfigCount, (Object)warningCount);
    }

    public static int getWarningCount() {
        return warningCount;
    }

    public static void clearCaches() {
        parsedClassVisitors.clear();
        modConfigMap.clear();
    }

    private static void startJarSearching() {
        File mcDir = new File(".");
        List maven_canidates = LibraryManager.flattenLists((File)mcDir);
        List file_canidates = LibraryManager.gatherLegacyCanidates((File)mcDir);
        for (Artifact artifact : maven_canidates) {
            File target;
            if ((artifact = Repository.resolveAll((Artifact)artifact)) == null || file_canidates.contains(target = artifact.getFile())) continue;
            file_canidates.add(target);
        }
        earlyModIDs.addAll(Arrays.asList("minecraft", "mcp", "FML", "forge"));
        for (File modFile : file_canidates) {
            FermiumJarScanner.searchJarFile(modFile);
        }
    }

    private static void searchJarFile(File modFile) {
        try (JarFile jar = new JarFile(modFile);){
            ZipEntry modInfo = jar.getEntry("mcmod.info");
            if (modInfo != null) {
                try {
                    Throwable throwable = null;
                    try (InputStream inputStream = jar.getInputStream(modInfo);){
                        InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
                        JsonElement rootElement = new JsonParser().parse((Reader)reader);
                        FermiumJarScanner.searchModInfoRecursive(rootElement);
                    }
                    catch (Throwable reader) {
                        Throwable throwable2 = reader;
                        throw reader;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            for (ZipEntry zipEntry : Collections.list(jar.entries())) {
                ASMClassVisitor visitedClass;
                if (zipEntry.getName().contains("__MACOSX") || zipEntry.getName().contains("module-info") || zipEntry.getName().contains("org/spongepowered") || zipEntry.getName().contains("it/unimi") || zipEntry.getName().contains("kotlin")) continue;
                if (zipEntry.getName().contains("net/jan/moddirector")) {
                    earlyModIDs.add("moddirector");
                    return;
                }
                if (zipEntry.getName().contains("git/jbredwards/jsonpaintings")) {
                    earlyModIDs.add("jsonpaintings");
                    return;
                }
                if (zipEntry.getName().contains("net/optifine")) {
                    earlyModIDs.add("optifine");
                    return;
                }
                if (!classFilePattern.matcher(zipEntry.getName()).matches()) continue;
                try (InputStream inputStream = jar.getInputStream(zipEntry);){
                    ClassReader reader = new ClassReader(inputStream);
                    visitedClass = new ASMClassVisitor();
                    reader.accept((ClassVisitor)visitedClass, 0);
                }
                catch (Exception ex) {
                    LOGGER.log(Level.INFO, "FermiumJarScanner failed to search class file {} in {}, likely fine to ignore.", (Object)zipEntry.getName(), (Object)jar.getName());
                    continue;
                }
                FermiumJarScanner.parseModVisitor(visitedClass);
                parsedClassVisitors.add(visitedClass);
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.ERROR, "FermiumJarScanner failed to search jar file {}.", (Object)modFile.getName());
        }
    }

    private static void searchModInfoRecursive(JsonElement element) {
        block5: {
            block4: {
                if (!(element instanceof JsonObject)) break block4;
                if (((JsonObject)element).has("modid")) {
                    earlyModIDs.add(((JsonObject)element).get("modid").getAsString().toLowerCase());
                } else {
                    for (Map.Entry entry : ((JsonObject)element).entrySet()) {
                        FermiumJarScanner.searchModInfoRecursive((JsonElement)entry.getValue());
                    }
                }
                break block5;
            }
            if (!(element instanceof JsonArray)) break block5;
            for (JsonElement elem : (JsonArray)element) {
                FermiumJarScanner.searchModInfoRecursive(elem);
            }
        }
    }

    private static void parseModVisitor(ASMClassVisitor visitedClass) {
        String modid = visitedClass.modid;
        if (modid != null && !modid.isEmpty()) {
            earlyModIDs.add(modid);
        }
    }

    private static void parseMixinConfigVisitor(ASMClassVisitor visitedClass) {
        String mixinConfigName = visitedClass.mixinConfigName;
        if (mixinConfigName != null && !mixinConfigName.isEmpty()) {
            for (ASMClassVisitor.ASMFieldVisitor parsedField : visitedClass.parsedFieldVisitors) {
                ++mixinConfigCount;
                boolean shouldApply = FermiumJarScanner.getRawBooleanConfigValue(mixinConfigName, parsedField.configFieldName, parsedField.defaultValue);
                if (!shouldApply) continue;
                if (!FermiumJarScanner.skipCompatHandlingChecks()) {
                    for (ASMClassVisitor.CompatHandlingAnnotation compatAnno : parsedField.compatHandlingAnnotations) {
                        if (compatAnno.desired == FermiumJarScanner.isModPresent(compatAnno.modid)) continue;
                        if (compatAnno.warnIngame) {
                            ++warningCount;
                        }
                        if (compatAnno.disableMixin) {
                            shouldApply = false;
                            LOGGER.log(Level.ERROR, "FermiumMixinConfig config \"{}\" from {} disabled as incompatible {} {}: {}.", (Object)parsedField.configFieldName, (Object)mixinConfigName, (Object)(compatAnno.desired ? "without" : "with"), (Object)compatAnno.modid, (Object)compatAnno.reason);
                            continue;
                        }
                        LOGGER.log(Level.WARN, "FermiumMixinConfig config \"{}\" from {} may have issues {} {}: {}.", (Object)parsedField.configFieldName, (Object)mixinConfigName, (Object)(compatAnno.desired ? "without" : "with"), (Object)compatAnno.modid, (Object)compatAnno.reason);
                    }
                }
                if (!shouldApply) continue;
                LOGGER.log(Level.INFO, "FermiumMixinConfig enqueueing mixin(s) parsed from annotated config {} from {}.", (Object)parsedField.configFieldName, (Object)mixinConfigName);
                if (parsedField.earlyMixinName != null) {
                    FermiumRegistryAPI.enqueueMixin(false, parsedField.earlyMixinName);
                }
                if (parsedField.lateMixinName == null) continue;
                FermiumRegistryAPI.enqueueMixin(true, parsedField.lateMixinName);
            }
        }
    }

    private static boolean skipCompatHandlingChecks() {
        if (skipCompatHandlingChecks == null && (skipCompatHandlingChecks = Boolean.valueOf(FermiumJarScanner.getRawBooleanConfigValue("fermiumbooter", "Override Mixin Config Compatibility Checks", false))).booleanValue()) {
            LOGGER.log(Level.WARN, "FermiumMixinConfig detected Override Mixin Config Compatibility Checks as enabled, good luck, don't report issues.");
        }
        return skipCompatHandlingChecks;
    }

    private static boolean getRawBooleanConfigValue(String modConfigName, String configFieldName, boolean defaultValue) {
        String modConfigString;
        if (!modConfigMap.containsKey(modConfigName)) {
            File configFile = new File("config", modConfigName + ".cfg");
            String rawConfigString = null;
            if (configFile.exists() && configFile.isFile()) {
                try (Stream<String> stream = Files.lines(configFile.toPath());){
                    rawConfigString = stream.filter(s -> s.trim().startsWith("B:")).collect(Collectors.joining());
                }
                catch (Exception ex) {
                    LOGGER.log(Level.ERROR, "FermiumMixinConfig failed to read config {}.cfg: {}.", (Object)modConfigName, (Object)ex);
                    rawConfigString = null;
                }
            }
            if (rawConfigString == null) {
                LOGGER.log(Level.WARN, "FermiumMixinConfig config {}.cfg missing or failed to read, using default values.", (Object)modConfigName);
            }
            modConfigMap.put(modConfigName, rawConfigString);
        }
        if ((modConfigString = modConfigMap.get(modConfigName)) == null) {
            return defaultValue;
        }
        if (modConfigString.contains("B:\"" + configFieldName + "\"=")) {
            return modConfigString.contains("B:\"" + configFieldName + "\"=true");
        }
        return defaultValue;
    }
}

