/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.mixinsquared.reflection;

import com.bawnorton.mixinsquared.reflection.FieldReference;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.spongepowered.asm.mixin.transformer.ext.Extensions;
import org.spongepowered.asm.mixin.transformer.ext.IExtension;
import org.spongepowered.asm.mixin.transformer.ext.IExtensionRegistry;

@ApiStatus.Internal
public final class ExtensionsExtension {
    private final Extensions reference;
    private final FieldReference<List<IExtension>> extensionsField;
    private final FieldReference<List<IExtension>> activeExtensionsField;

    public ExtensionsExtension(Extensions reference) {
        this.reference = reference;
        this.extensionsField = new FieldReference(reference.getClass(), "extensions");
        this.activeExtensionsField = new FieldReference(reference.getClass(), "activeExtensions");
    }

    public static void tryAs(IExtensionRegistry reference, Consumer<ExtensionsExtension> consumer) {
        if (reference instanceof Extensions) {
            consumer.accept(new ExtensionsExtension((Extensions)reference));
        }
    }

    public List<IExtension> getExtensions() {
        return this.extensionsField.get(this.reference);
    }

    public List<IExtension> getActiveExtensions() {
        return this.reference.getActiveExtensions();
    }

    public void setActiveExtensions(List<IExtension> extensions) {
        this.activeExtensionsField.set(this.reference, extensions);
    }
}

