/*
 * Decompiled with CFR 0.152.
 */
package fermiumbooter.util;

import fermiumbooter.config.FermiumBooterConfig;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.launchwrapper.Launch;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;
import org.spongepowered.asm.mixin.throwables.MixinError;
import org.spongepowered.asm.mixin.throwables.MixinException;

public class CustomLogger {
    public static final String LOGGER_NAME = "fermiumbooter";
    public static Path LOG_PATH;
    public static final Set<String> mixinErrors;

    public static void init() {
        LOG_PATH = Paths.get(Launch.minecraftHome.getPath(), "logs", "fermiumbooter.log");
        try {
            Files.createDirectories(LOG_PATH.getParent(), new FileAttribute[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        FileAppender appender = ((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)FileAppender.newBuilder().withFileName(LOG_PATH.toString()).setName(LOGGER_NAME)).withAppend(false).setLayout((Layout)new AbstractStringLayout(Charset.defaultCharset()){

            public String toSerializable(LogEvent event) {
                Throwable cause = CustomLogger.getCause(event.getThrown());
                if (cause == null && event.getMessage().getFormattedMessage().startsWith("FermiumMixinConfig config")) {
                    return event.getMessage().getFormattedMessage().replaceFirst("FermiumMixinConfig config", "Fermium Config Warning:" + System.lineSeparator() + "\t") + System.lineSeparator();
                }
                if (cause instanceof MixinException || cause instanceof MixinError) {
                    String simpleMessage = cause.getClass().getSimpleName() + ":" + System.lineSeparator() + "\t" + cause.getMessage().split("[\\r\\n]")[0] + System.lineSeparator();
                    if (FermiumBooterConfig.appendGeneralMixinExceptionsToCrashReports) {
                        mixinErrors.add(simpleMessage);
                    }
                    return "General Mixin Error " + simpleMessage;
                }
                return "Unhandled Error:" + System.lineSeparator() + "\t" + event.getMessage().getFormattedMessage() + System.lineSeparator();
            }
        })).setConfiguration(config)).build();
        appender.start();
        config.addAppender((Appender)appender);
        config.getRootLogger().addAppender((Appender)appender, Level.WARN, (Filter)new AbstractFilter(){

            public Filter.Result filter(LogEvent event) {
                if (event.getMessage() == null) {
                    return Filter.Result.DENY;
                }
                Throwable cause = CustomLogger.getCause(event.getThrown());
                if (cause == null) {
                    return event.getMessage().getFormattedMessage().startsWith("FermiumMixinConfig config") ? Filter.Result.ACCEPT : Filter.Result.DENY;
                }
                return cause instanceof MixinException || cause instanceof MixinError ? Filter.Result.ACCEPT : Filter.Result.DENY;
            }
        });
        ctx.updateLoggers();
    }

    @Nullable
    private static Throwable getCause(Throwable throwable) {
        Throwable cause;
        if (throwable == null) {
            return null;
        }
        HashSet<Throwable> seen = new HashSet<Throwable>();
        while ((cause = throwable.getCause()) != null && seen.add(cause)) {
            throwable = cause;
        }
        return throwable;
    }

    static {
        mixinErrors = Collections.synchronizedSet(new HashSet());
    }
}

