/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.captcha.client;

import java.util.Random;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum CaptchaEnum {
    ROBOT("robot", 0),
    MATH("math", 1),
    TEXT("text", 2),
    IMAGE("image", 3),
    SLIDE("slide", 4),
    WINRAR("winrar", 5);

    private final String name;
    private final int id;

    private CaptchaEnum(String name, int id) {
        this.name = name;
        this.id = id;
    }

    public String getCaptchaName() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    @NotNull
    public static CaptchaEnum getByName(@Nullable String value) {
        for (CaptchaEnum captcha : CaptchaEnum.values()) {
            if (!captcha.name.equals(value)) continue;
            return captcha;
        }
        return ROBOT;
    }

    public static CaptchaEnum getRandom(Random random) {
        int pick = random.nextInt(CaptchaEnum.values().length);
        CaptchaEnum choice = CaptchaEnum.values()[pick];
        if (choice == WINRAR && !random.nextBoolean()) {
            choice = MATH;
        }
        return choice;
    }
}

