/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.captcha.client.screen.image;

import com.mrbysco.captcha.client.screen.CaptchaScreen;
import com.mrbysco.captcha.client.screen.image.ImageEnum;
import com.mrbysco.captcha.client.screen.widget.ToggleButton;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_5489;
import net.minecraft.class_9848;

public class ImageScreen
extends CaptchaScreen {
    private static final Random random = new Random();
    private class_2960 IMAGE = class_2960.method_60655((String)"captcha", (String)"textures/gui/warp.png");
    private int SQUARE_SIZE = 64;
    private boolean[][] correctSquares = new boolean[4][4];
    private int tries = 0;
    private final ToggleButton[][] buttons = new ToggleButton[4][4];
    private class_4185 button;
    protected class_5489 error = class_5489.field_26528;
    protected int errorY = 406;

    public ImageScreen(String code, int maxCompletionTime) {
        super((class_2561)class_2561.method_43471((String)"captcha.image.screen"), code, maxCompletionTime);
    }

    protected void method_25426() {
        super.method_25426();
        this.message = class_5489.method_30892((class_327)this.field_22793, (class_2561[])new class_2561[]{class_2561.method_43473(), class_2561.method_43471((String)"captcha.image.screen"), class_2561.method_43473(), class_2561.method_43471((String)"captcha.image.none")});
        this.updateImageSize();
        int startX = (this.field_22789 - this.SQUARE_SIZE * 4) / 2 - 4;
        int startY = (this.field_22790 - this.SQUARE_SIZE * 4) / 2 - 4;
        int n = this.message.method_30887();
        Objects.requireNonNull(this.field_22793);
        this.messageY = startY - n * 9 - 12;
        for (int row = 0; row < 4; ++row) {
            for (int col = 0; col < 4; ++col) {
                int id = row + col;
                int x = startX + col * this.SQUARE_SIZE + col * 4;
                int y = startY + row * this.SQUARE_SIZE + row * 4;
                int textureX = col * this.SQUARE_SIZE;
                int textureY = row * this.SQUARE_SIZE;
                ToggleButton toggleButton = new ToggleButton(x, y, this.SQUARE_SIZE, this.SQUARE_SIZE, textureX, textureY, this.IMAGE, 128, 128, button -> {
                    ((ToggleButton)button).setClicked(!((ToggleButton)button).isClicked());
                    this.updateButton();
                }, (class_2561)class_2561.method_43470((String)("square " + id)));
                this.buttons[row][col] = toggleButton;
                this.method_37063((class_364)toggleButton);
            }
        }
        this.changeImage(false);
        this.errorY = startY + this.SQUARE_SIZE * 4 + 16;
        this.button = class_4185.method_46430((class_2561)class_2561.method_43471((String)"captcha.image.skip"), button -> this.checkSquares()).method_46434(this.field_22789 / 2 - 60, startY + this.SQUARE_SIZE * 4 + 36, 120, 20).method_46431();
        this.method_37063((class_364)this.button);
    }

    private void updateImageSize() {
        this.SQUARE_SIZE = 32;
    }

    public void method_25410(class_310 minecraft, int width, int height) {
        super.method_25410(minecraft, width, height);
        this.updateImageSize();
    }

    private void changeImage(boolean reset) {
        ImageEnum image = ImageEnum.getRandom(random);
        this.IMAGE = class_2960.method_60655((String)"captcha", (String)("textures/gui/" + image.getImageName() + ".png"));
        List entries = image.getDataMap().entrySet().stream().toList();
        Map.Entry entry = (Map.Entry)entries.get(random.nextInt(entries.size()));
        String object = (String)entry.getKey();
        this.correctSquares = (boolean[][])entry.getValue();
        if (this.buttons.length > 0) {
            for (int x = 0; x < 4; ++x) {
                for (int y = 0; y < 4; ++y) {
                    ToggleButton toggleButton = this.buttons[x][y];
                    if (toggleButton == null) continue;
                    toggleButton.setResourceLocation(this.IMAGE);
                    toggleButton.setClicked(false);
                }
            }
        }
        if (reset) {
            this.error = class_5489.method_30892((class_327)this.field_22793, (class_2561[])new class_2561[]{class_2561.method_43471((String)"captcha.text.failed").method_27692(class_124.field_1061), class_2561.method_43471((String)"captcha.text.failed2").method_27692(class_124.field_1061)});
        }
        this.message = class_5489.method_30892((class_327)this.field_22793, (class_2561[])new class_2561[]{class_2561.method_43471((String)"captcha.image.screen"), class_2561.method_43473(), class_2561.method_43470((String)object).method_27692(class_124.field_1065), class_2561.method_43473(), class_2561.method_43471((String)"captcha.image.none")});
    }

    private void checkSquares() {
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 4; ++y) {
                ToggleButton toggleButton = this.buttons[x][y];
                if (toggleButton == null || toggleButton.isClicked() == this.correctSquares[x][y]) continue;
                this.resetCaptcha();
                return;
            }
        }
        this.completeCaptcha();
    }

    private void updateButton() {
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 4; ++y) {
                ToggleButton toggleButton = this.buttons[x][y];
                if (toggleButton == null || !toggleButton.isClicked()) continue;
                this.button.method_25355((class_2561)class_2561.method_43471((String)"captcha.image.verify"));
                return;
            }
        }
        this.button.method_25355((class_2561)class_2561.method_43471((String)"captcha.image.skip"));
    }

    @Override
    public void method_25393() {
        super.method_25393();
    }

    @Override
    public void resetCaptcha() {
        super.resetCaptcha();
        if (this.timeWaited > this.getMaxCompletionTime()) {
            this.changeImage(true);
            this.tries = 0;
            return;
        }
        if (this.tries > 1) {
            this.tries = 0;
            this.changeImage(true);
        } else {
            ++this.tries;
        }
    }

    @Override
    public int getMaxCompletionTime() {
        return super.getMaxCompletionTime();
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        this.error.method_73212(guiGraphics, class_5489.class_11735.field_62010, this.field_22789 / 2, this.errorY, 10, false, class_9848.method_61334((int)0));
    }
}

